/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Demo of	bar graph
****************************************************************/

project "xbar"

include "tdoms.pro"
include "gdoms.pro"
include "gglobs.pro"
include "tpreds.pro"
include "gpreds.pro"
include "gbar.pro"

goal
  Theta=0.3,
  Graph1Ratio=0.5,
  graphics(1,1,1),
  gwrite(0,12,"3-D BAR-CHART.",3,0),
  gwrite(1,12,"--------------",2,0),
  gwrite(2,1,"SALES IN BILLION $",1,1),
  gwrite(22,0,"Resolution: 320x200 pixels in 4 colors",1,0),
  BarGraph3D(3,6,4,4,Theta,Graph1Ratio,
  	[bar(2,"",1,2),
  	 bar(3,"1984",1,3),
  	 bar(5,"",1,2),
	 space,
	 bar(4,"",1,2),
	 bar(7,"1985",1,3),
	 bar(7,"",1,2),
	 space,
	 bar(4,"",1,2),
	 bar(7,"1986",1,3),
	 bar(7,"",1,2),
	 space,
  	 space,
  	 space,
  	 bar(10,"Estim. 1987",1,3)],_),
  gwrite(24,0,"Press space bar",1,0),
  readchar(_),
  graphics(2,1,1),
  makewindow(1,1,0,"",0,0,25,80),
  gwrite(0,30,"2-D BAR-CHART",1,0),
  gwrite(1,30,"-------------",1,0),
  Graph2Ratio=0.9,
  gwrite(24,0,"Resolution: 640x200 in 2 colors.",1,0),
  BarGraph(5,5,4,4,
  	Graph2Ratio,
  	[bar(52,"",1,0),
  	 bar(33,"1983",1,1),
  	 bar(70,"",1,0),
  	 space,
  	 bar(49,"",1,1),
  	 bar(80,"1984",1,0),
  	 bar(100,"",1,1),
  	 space,
  	 bar(40,"",1,0),
  	 bar(50,"1985",1,1),
  	 bar(70,"",1,0),
	 space,
  	 bar(100,"Reference",1,1)],SFactor),
  gwrite(22,0,"The graph is automatically scaled to fit a specified area.",1,0),
  str_real(ScaleStr,SFactor),
  concat("The scaling factor in this example is =",ScaleStr,Str1),
  gwrite(23,0,Str1,1,0),
  gwrite(24,50,"Press space bar",1,0),
  readchar(_),
  clearwindow,
  gwrite(23,0,"Enter E if an EGA card is installed (press any other key to end)",1,0),
  readchar(E),
  E= 'e',
  graphics(4,1,1),
  makewindow(4,7,0,"",0,0,25,80),
  Graph3Ratio=0.9,
  gwrite(23,0,"Resolution: EGA 640 x 200 in 16 Colors",1,0),
  BarGraph3D(7,7,7,7,Theta,Graph3Ratio,
  	[bar(2,"",1,2),
  	 bar(3,"1983",3,4),
  	 bar(5,"",5,6),
  	 space,
  	 bar(4,"",7,8),
  	 bar(7,"1984",9,10),
  	 bar(7,"",11,12),
  	 space,
  	 bar(4,"",13,14),
  	 bar(7,"1985",15,1),
  	 bar(7,"",2,3),
	 space,
  	 bar(10,"Reference",4,5)],_),
  gwrite(24,0,"Press space bar to continue",1,0),
  readchar(_),
  graphics(5,1,1),
  makewindow(4,7,0,"",0,0,25,80),
  Graph3Ratio=0.9,
  gwrite(23,0,"Resolution: EGA 640 x 350 in 16 Colors",1,0),
  BarGraph3D(7,7,7,7,Theta,Graph3Ratio,
  	[bar(2,"",1,2),
  	 bar(3,"1983",3,4),
  	 bar(5,"",5,6),
  	 space,
  	 bar(4,"",7,8),
  	 bar(7,"1984",9,10),
  	 bar(7,"",11,12),
  	 space,
  	 bar(4,"",13,14),
  	 bar(7,"1985",15,1),
  	 bar(7,"",2,3),
	 space,
  	 bar(10,"Reference",4,5)],_),
  gwrite(24,0,"Press space bar",1,0),
  readchar(_).
