
/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Demo of menu
****************************************************************/

include "tdoms.pro"
include "tpreds.pro"
include "menu.pro"

DOMAINS
  numberlist=integer*

PREDICATES
  ask(numberlist,integer)
  career(integer,string)
  q(integer,string,stringlist)

GOAL
	makewindow(1,32,0,"",0,0,25,80),
	ask([1,2,3,4],Total),career(Total,Job),
	makewindow(1,23,71,"Career",20,10,5,50),
	nl,write("        You should be in ",Job),readchar(_).
         
CLAUSES
  q(4,"If you were at a party and saw someone standing alone, would you:",
	["organise lots of people to go over and talk to that person",
	"go over and talk to him or her yourself",
	"just smile at him or her sympathetically",
	"take no notice"]).

  q(3,"Which of the following activities do you most enjoy?",
	[parties,"going out for a meal",sports,cinema,"flower arranging",
	"reading a book"]).   

  q(2,"Which one of the following best describes you?",
	[obstinate,determined,ambitious,considerate,thoughtful,
	"couldn't care what turns up"]).     
   
  q(1,"Which one of the following best describes you?",
	[wild,"very extroverted",extrovert,happy,"quiet and refined",
	quiet,"very introverted","extremely shy"]).

  ask([],0).
  ask([X | Y],S):-
	ask(Y,T),q(X,Title,Choicelist),
	menu(10,7,23,71,Choicelist,Title,1,ChoiceNo),
	S=T+ChoiceNo.
     
  career(Total,advertising):-Total<8.          
  career(Total,computing):-Total>7,Total<20.
  career(_,archaeology).
