
/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Common interest group
****************************************************************/

code=3000

include "tdoms.pro"

DOMAINS
  FNAME=SYMBOL
  FNAMELIST = FNAME*
  TYPE = int(); str(); real()

DOMAINS
  /* Domains for the  demo */
  Name, Address = STRING
  Age		= INTEGER
  Sex		= m or f
  Interest	= symbol
  Interests	= Interest*
  FILE	= textfile

DATABASE
  /* Database declarations used in SCRHND */
  insmode			/* Global insertmode */
  actfield(FNAME)		/* Actual field */
  screen(SYMBOL,DBASEDOM)	/* Saving different screens */
  value(FNAME,STRING)		/* value of a field */
  field(FNAME,TYPE,ROW,COL,LEN) /* Screen definition */
  txtfield(ROW,COL,LEN,STRING)
  windowsize(ROW,COL).
  notopline

  /* Database predicates used in VSCRHND */
  windowstart(ROW,COL)
  mycursord(ROW,COL)

  /* Database declarations used in LINEINP */
  lineinpstate(STRING,COL)
  lineinpflag

  /* Local database */
  person(Name,Address,Age,Sex,Interests)

include "tpreds.pro"
include "menu.pro"
include "status.pro"
include "lineinp.pro"
include "filename.pro"
include "scrhnd.pro"

/*******************************************************************
			D E M O 				    
*******************************************************************/

PREDICATES
  /* Predicates for the people demo */
  gsex(STRING,Sex)
  ginterests(STRING,Interests)
  gperson(Dbasedom)
  wperson(Dbasedom)
  listdba
  wr(DBASEDOM)
  process(INTEGER)
  nondeterm member(INTEREST,INTERESTS)  

GOAL
	makewindow(77,36,0,"",0,0,24,80),
	makestatus(112,""),
	consult("xclub.scr"),
	consult("xclub.dba"),
	repeat,
	changestatus(" Select an option."),
	menu(10,25,71,23,
		["Save new database",
		 "Input new person",
		 "Update an entry",
		 "Find people with your interests",
		 "List database"],
		 "CHOICE",
		 4,Ch),
	 process(CH),CH=0,!.


CLAUSES
  member(X,[X|_]).
  member(X,[_|L]):-member(X,L).

  field_action(_):-fail.
  field_value(FNAME,VALUE):-value(FNAME,VALUE),!.
  noinput(_):-fail.
  		
  process(0).
  process(1):-
	changestatus("Type in a name for the database."),
	readfilename(10,10,7,7,dba,"xclub.dba",FILE),
	openwrite(textfile,FILE),
	writedevice(textfile),
	listdba,
	closefile(textfile).
  process(2):-
	retract(value(_,_)),fail.
  process(2):-
	createwindow(off),
	changestatus(" Input new person's details.   Move cursor with arrows.      F10:end"),
	scrhnd(off,KEY),not(KEY=esc),
	gperson(P),assert(P),fail.
  process(2):-
	removewindow.
  process(3):-
	retract(value(_,_)),fail.
  process(3):-
	createwindow(off),
	changestatus(" To find old record, give a name and press F10."),
	scrhnd(off,KEY1),not(KEY1=esc),
	value(f1,N),
	Name=N,
	person(Name,Ad,Al,K,I),
	wperson(person(Name,Ad,Al,K,I)),
	changestatus("Now you can modify the data. Press F10 to finish."),
	scrhnd(off,KEY2),not(KEY2=esc),
	retract(person(Name,Ad,Al,K,I)),
	gperson(P),
	asserta(P),
	removewindow,!.
  process(3):-
	removewindow.
  process(4):-
	retract(value(_,_)),fail.
  process(4):-
	createwindow(off),
	changestatus(" Type some interest and then press F10."),
	scrhnd(off,KEY1),not(KEY1=esc),
	value(f5,S5), ginterests(S5,Interests),
	person(Name,Ad,Al,K,I),
	member(X,Interests),member(X,I),
	wperson(person(Name,Ad,Al,K,I)),
	changestatus(" To inspect each matching entry, press F10 repeatedly."),
	scrhnd(off,KEY2),not(KEY2=esc),
	fail.
  process(4):-
	removewindow.
  process(5):-
	clearwindow,listdba.


/**********************************************************************
	Write and get data to and from the "value" predicate
**********************************************************************/

  wperson(_):-retract(value(_,_)),fail.
  wperson(person(Name,Address,Age,Sex,Interests)):-
	Name=S1,	assert(value(f1,S1)),
	Address=S2,	assert(value(f2,S2)),
	str_int(S3,Age),assert(value(f3,S3)), 
	gsex(S4,Sex),	assert(value(f4,S4)),
	ginterests(S5,Interests),assert(value(f5,S5)).


  gperson(person(Name,Address,Age,Sex,Interests)):-
	value(f1,S1), Name=S1,
	value(f2,S2), Address=S2,
	value(f3,S3), str_int(S3,Age),
	value(f4,S4), gsex(S4,Sex),
	value(f5,S5), ginterests(S5,Interests),!.

/**********************************************************************
	Conversions between a string and the corresponding domain
**********************************************************************/

  gsex("m",m).
  gsex("f",f).
  
  ginterests("",[]):-!.
  ginterests(S,L):-bound(S),fronttoken(S,",",S1),!,ginterests(S1,L).
  ginterests(S,[H|T]):-bound(S),!,fronttoken(S,H,S1),ginterests(S1,T).
  ginterests(S,[H]):-bound(H),!,H=S.
  ginterests(S,[H|T]):-bound(H),
		ginterests(SS,T),concat(H,",",SSS),
		concat(SSS,SS,S).


/**********************************************************************
		List the database
**********************************************************************/

  wr(X):-write(X),nl.

  listdba:-
	person(A,B,C,D,E),
	wr(person(A,B,C,D,E)),
	fail.
  listdba.
