/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

	Complete serial communications package
       
****************************************************************/
/*
nobreak
*/
project "xcommu"

domains
  file	= sf; df  

database
  editbuf(string)
  port(integer,string)

include "tdoms.pro"
include "comglobs.pro"
include "tpreds.pro"
include "menu.pro"

predicates
  decide(integer)
  
  /* Polled transmission with time out */
  send_str(string,integer)
  send_ch(char,integer,integer)
  send_ch_CRLF(char,integer,integer)
  receive_str(integer)
  receive_ch(char,integer,integer)
  wait_ok(integer,integer,integer)

  /* Interrupt based Terminal Emulation */
  interactive_com
  chk_rdch
  chk_wrch
  rdch_CRLF_RS232(integer,char)

  /* Interrupt based Terminal Modem Communication */
  interactive_modem
  chk_rdmodem
  chk_wrmodem
  chk_modem(string,string)
  init_modem_line
  chk_modem_delay(integer,integer)
  send_str_modem(string,integer,integer)
  trans_modem(string,integer,integer,integer)
  receive_modem(integer,integer,integer)

  /* Read and write to console the status of transmission */
  wr_status(integer)
  chk_stat(integer,integer,string)

  /* Miscellaneous */
  mess(string)
  rdch_keyb(char)
  get_FileName(string,string)

GOAL
	makewindow(1, 23,130," Message window ", 4,35,8,45),
	makewindow(2, 42,36," Transmit window ", 3,0,10,80),
	makewindow(3, 63,5," Receive window ", 13,0,10,80),
	makewindow(6, 10,7," Configuration ",0,0,3,80),
	assertz(editbuf("")),
	asserta(port(1,"COMMU")),
	asserta(port(2,"MODEM")),
	repeat,
	port(ComPort,"COMMU"),
	port(ModPort,"MODEM"),
	shiftwindow(6), clearwindow,
	write(" The communication port is COM",ComPort,",  The modem is COM",ModPort),
	shiftwindow(2), shiftwindow(3),
	menu(10,20,64,23,
	     ["Open communication port",     /* 1 */
  	      "Close communication port",         /* 2 */
     	      "Send File using Protocol",         /* 3 */
     	      "Receive File using Protocol",      /* 4 */
     	      "Terminal Mode",                    /* 5 */
     	      "No of Characters in buffers",      /* 6 */
 	      "",                 
     	      "Initialize modem port",      	/* 8 */
     	      "Close modem port",      		/* 9 */
     	      "Send File using modem",          /* 10 */
     	      "Receive File using modem",       /* 11 */
     	      "Terminal Mode using modem",      /* 12 */
 	      "",
     	      "Editor",     			/* 14 */
     	      "Operating system",    		/* 15 */
	      "Switch COM PORTS",      		/* 16 */
     	      "Quit"],                          /* 17 */
              "Choose an option",0,Choice),
	decide(Choice),
	fail.

CLAUSES
/* Open communication port	*/
  decide(1):-
	port(PortNo,"COMMU"),            /* COM Port is PortNo */
	InputBufSize	=	256,	/* Size of input buffer */
	OutputBufSize	=	256,	/* Size of output buffer */
	BaudRate	=	7,	/* 9600 bits per second	*/
	Parity		=	0,	/* No parity		*/
	WordLength	=	3,	/* Eight data bits	*/
	StopBits	=	0,	/* One stop bits	*/
	menu(10,10,64,23,["Without RTS/CTS and Xon/Xoff",
  	            "Xon/Xoff without RTS/CTS",
	            "RTS/CTS without Xon/Xoff",
	            "RTS/CTS and Xon/Xoff"],
	            "Choose an option",0,Choice),
  	Protocol	 = CHOICE-1,
  	openRs232(PortNo, InputBufSize, OutputBufSize, BaudRate, Parity,
  		  WordLength, StopBits, Protocol),!.

  decide(1):-
        mess("Open RS232 failed").

  /* Close communication port */
  decide(2):-
        port(PortNo,"COMMU"),closeRS232(PortNo),!.	/* Close PortNo */
  decide(2):-
        mess("Close RS232 failed").

  /*	Send file using protocol	*/
  decide(3):-
        port(PortNo,"COMMU"),
  	shiftwindow(2),
  	get_filename("Name of file to be transmitted: ",FileName),
	file_str(FileName,S), send_str(S,PortNo),!.
  decide(3):-mess("Transmission failed").

  /*	Receive file using protocol	*/
  decide(4):-
        port(PortNo,"COMMU"),
  	shiftwindow(3),
  	get_filename("Name of file to be received: ",FileName),
  	openwrite(df,FileName), receive_str(PortNo), closefile(df),!.
  decide(4):-mess("Transmission failed").

  /* Terminal Mode */
  decide(5):-
  	shiftwindow(2), write("\nTerminal Mode, Press Esc to abort\n"),
  	interactive_com.
  
  /* Number of characters in buffers */
  decide(6):-
        port(PortNo,"COMMU"),
  	queuesize_RS232(PortNo,CharInput,CharOutput),!,
  	makewindow(5,109,82," Information ",6,20,5,50),
  	write("\nNo of Characters in input buffer  : ",CharInput),
  	write("\nNo of Characters in output buffer : ",Charoutput),
  	readchar(_), removewindow.
  decide(6):-mess("No Queues").

  /* Initialize modem port */
  decide(8):-
	port(PortNo,"MODEM"),		/* PortNo is Modem Port */
	InputBufSize	=	256,	/* Size of input buffer */
	OutputBufSize	=	256,	/* Size of output buffer */
	BaudRate	=	4,	/* 1200 bits per second	*/
	Parity		=	2,	/* Even parity		*/
	WordLength	=	2,	/* Seven data bits	*/
	StopBits	=	0,	/* One stop bits	*/
  	Protocol	=	3,	/* RTS/CTS and Xon/Xoff */
  	openRs232(PortNo, InputBufSize, OutputBufSize, BaudRate, Parity,
  		  WordLength, StopBits, Protocol),
  	SetModemMode(PortNo,"AT",'\013',25),!.

  decide(8):-mess("Initialization of MODEM port failed").

  /* Close modem port	*/
  decide(9):-	
         port(PortNo,"MODEM"),	
         closeRS232(PortNo),!.  	/* Close PortNo */
  decide(9):-mess("Close Modem Port failed").

  /* Send file using modem port	*/
  decide(10):-	
        port(PortNo,"MODEM"),	
  	shiftwindow(2),
  	get_filename("Name of file to be transmitted: ",FileName),
	file_str(FileName,S),
	send_str_modem(S,PortNo,1),!.
  decide(10):-mess("Transmission via modem failed").

  /* Receive file using modem port	*/
  decide(11):-	
        port(PortNo,"MODEM"),	
  	shiftwindow(3),
  	get_filename("Name of file to be received: ",FileName),
  	openwrite(df,FileName),
  	receive_str(PortNo), closefile(df), !.
  decide(11):-mess("Transmission via Modem failed").

  /* Set modem in Terminal Mode */
  decide(12):-
  	shiftwindow(2),
  	init_modem_line,
  	write("\nTerminal Mode, Press Esc to abort\n"),
  	interactive_modem.
  
  /* Editor */
  decide(14):-
	makewindow(5,109,82," Edit Window ",6,10,15,60),
	editbuf(Str), edit(Str,Str2),
	retract(editbuf(Str)), assert(editbuf(Str2)),!.

  /* Operating system */
  decide(15):-system("").
  
  /* option to switch comm ports commu = 2 and modem = 1 */
  decide(16):-
      retract(port(_,_)), fail.
  decide(16):-
      assert(port(1,"MODEM")),
      assert(port(2,"COMMU")).    
      
  /* Quit */
  decide(17):-         
         closeRS232(1),fail.  	/* Close COM1 */
  decide(17):-         
         closeRS232(2),fail.  	/* Close COM2 */
  decide(17):-exit.


/****************************************************************
		Polled transmission with time out
****************************************************************/

  /* Transmit a string  */
  send_str("",_):-!.
  send_str(S,PortNo):-
	frontchar(S,CH,S2),
	write(CH), send_ch_CRLF(CH,50,PortNo),
	send_str(S2,PortNo).

  send_ch_CRLF('\10',I,PortNo):-
  	!,send_ch('\13',I,PortNo), send_ch('\10',I,PortNo).
  send_ch_CRLF(CH,I,PortNo):-send_ch(CH,I,PortNo).

  send_ch(CH,_,PortNo):-Txch_RS232(PortNo,CH),!.
  send_ch(CH,I,PortNo):-
  	status_RS232(PortNo,Status), !,
  	wait_ok(Status,I,I2), send_ch(CH,I2,PortNo).

  /* Receive a string and copy it to a file */
  receive_str(PortNo):-
	receive_ch(CH,50,PortNo),!, write(CH),
	writedevice(FP), writedevice(df), write(CH), writedevice(FP),
  	receive_str(PortNo).
  receive_str(_).

  receive_ch(CH,_,PortNo):-Rxch_RS232(PortNo,CH), CH<>'\013', !.
  receive_ch(CH,_,PortNo):-Rxch_RS232(PortNo,CH), !.
  receive_ch(CH,I,PortNo):-
  	status_RS232(PortNo,Status),
  	wait_ok(Status,I,I2), receive_ch(CH,I2,PortNo).

  /* Test for time out */
  wait_ok(_,I,I2):-I > 0, I2=I-1,ticks(10),!.
  wait_ok(Status,_,50):-wr_status(Status).

  /* Transmit a string using modem port */
  send_str_modem("",_,_):-!.
  send_str_modem(S,PortNo,ChCoun):-
	frontchar(S,CH,S2),
	write(CH), send_ch_CRLF(CH,50,PortNo),
	chk_modem_delay(ChCoun,NewChCoun),
	send_str_modem(S2,PortNo,NewChCoun).

  /* Some modem are without hand shake */
  chk_modem_delay(10,1):-!,Ticks(8).
  chk_modem_delay(I,I2):-I2=I+1.
  
  /* Demask status value */
  wr_status(0):-!.
  wr_status(Status):-
  	shiftwindow(WD), shiftwindow(1),
  	chk_stat(Status,1,  "Input Characters have been lost"),
  	chk_stat(Status,2,  "Parity Error"),
  	chk_stat(Status,4,  "Overrun detected"),
  	chk_stat(Status,8,  "Framing error detected"),
  	chk_stat(Status,16, "Break signal detected"),
  	chk_stat(Status,32, "An Xoff has been received"),
  	chk_stat(Status,64, "An Xon has been received"),
  	chk_stat(Status,128,"An Xoff has been transmitted"),
  	chk_stat(Status,256,"An Xon has been transmitted"),
  	chk_stat(Status,512,"Input buffer empty when attempt to read"),
  	chk_stat(Status,1024,"Output buffer full when attempt to write"),
  	write("\nPress Space to continue or Esc to abort"), readchar(Ch),
  	shiftwindow(2), shiftwindow(3),
  	shiftwindow(WD),CH<>'\27'.

  chk_stat(Status,BitMask,Mess):-
  	bitand(Status,BitMask,V), V<>0, !, nl, write(Mess).
  chk_stat(_,_,_).


/****************************************************************

		TERMINAL MODE
	Interrupt based transmission without time out

****************************************************************/

  /* Terminal Mode */
  interactive_com:-chk_rdch, chk_wrch,interactive_com.

  chk_rdch:-	
       port(PortNo,"COMMU"),	
       rdch_CRLF_RS232(PortNo,CH),!,shiftwindow(3), write(CH).
  chk_rdch.

  chk_wrch:-shiftwindow(2), cursor(R,C), cursor(R,C), not(keypressed),!.
  chk_wrch:-
        port(PortNo,"COMMU"),!,	
  	rdch_keyb(CH),CH<>'\027',
  	write(CH), 
  	Txch_RS232(PortNo,CH).
  
  rdch_CRLF_RS232(PortNo,CH):-Rxch_RS232(PortNo,CH), CH<>'\013',!.
  rdch_CRLF_RS232(PortNo,CH):-Rxch_RS232(PortNo,CH).


/****************************************************************

	     TERMINAL MODE - MODEM COMMUNICATION
	Interrupt based transmission without time out

****************************************************************/

  interactive_modem():-chk_rdmodem, chk_wrmodem,interactive_modem.
  
  chk_rdmodem:-RxStr_modem(Mess),shiftwindow(3), write(Mess), fail.
  chk_rdmodem.

  chk_wrmodem:-shiftwindow(2), cursor(R,C), cursor(R,C), not(keypressed),!.
  chk_wrmodem:-readln(L), upper_lower(L,L2), chk_modem(L,L2).

  /* Command to the modem when it is in terminal mode */
  /* Send a break signal */
  chk_modem(_,"break"):-!,
           port(PortNo,"MODEM"),!,	
           SetModemMode(PortNo,"AT",'\013',10),SendBreak_RS232.

  /* Prefix every commands with "AT" and suffix it with CR */
  chk_modem(_,"at on"):-!,
           port(PortNo,"MODEM"),!,	
           SetModemMode(PortNo,"AT",'\013',10).

  /* No transformation at all - might be useful when transmitting data */
  chk_modem(_,"at off"):-!,
           port(PortNo,"MODEM"),!,	
           SetModemMode(PortNo,"",'\013',10)./*No transform at all*/
  chk_modem(L,_)      :-TxStr_modem(L,_).

/****************************************************************

		MODEM SUPPORT PREDICATES

****************************************************************/

  init_modem_line:-
  	shiftwindow(OldWD),		/* Old window */
  	trans_modem("Z ",2,1,10),	/* Reset the modem to initial state */
  	trans_modem("C1",2,1,10),	/* Set carrier high */
  	shiftwindow(OldWd).

  trans_modem(Mstr,NoofAnsw,NoOFRetr,Delay):-
	ticks(10),
  	shiftwindow(2),			/* Transmission window */
  	write("\n" ,Mstr),
  	TxStr_modem(Mstr,_),		/* Command to modem */
  	shiftwindow(3),			/* Receive window */
  	receive_modem(NoofAnsw,NoOfRetr,Delay).

  receive_modem(0,_,_):-!.		/* No more to receive */
  receive_modem(I,R,Delay):-
	ticks(Delay),
  	RxStr_modem(Mess1),
	write(Mess1), I2=I-1, !,
	receive_modem(I2,R,50).	/* first delay is highest */

  receive_modem(_,1,_):-trans_modem("I2",5,0,400),!,fail.
	

/****************************************************************

		Miscellaneous

****************************************************************/

  mess(Str):-
  	shiftwindow(WD), shiftwindow(1),
  	write("\n\n",Str),
  	write("\nPress Space to continue"), readchar(_),
  	shiftwindow(2), shiftwindow(3),
  	shiftwindow(WD).

  /* Read char from keyboard and transform CR to LF */
  rdch_keyb(CH):-readchar(CH), CH<>'\013',!.
  rdch_keyb('\010'). /*CH = '\010'.*/

  /* Get filename from concole */
  get_FileName(Mess,FileName):-
  	makewindow(4,12,52," Input ",12,10,3,50),
  	write(Mess),
  	readln(FileName),FileName<>"",!,removewindow.
  get_FileName(_,FileName):-
  	makewindow(4,23,12," Input ",12,10,12,50),
  	disk(Disk), dir(Disk,"*.txt",FileName),!,removewindow,removewindow.
  get_FileName(_,""):-
  	removewindow, removewindow, fail.
