/************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

	Access a dBASE III(TM) (V1.1) compatible file from Prolog

	The two datafiles XDBASE3.DBF and XDBASE3.DBT must
	be present at the default directory.

*************************************************************/

project "xdbase3"

Domains
  File		= fp ; mfp

global predicates
  real_ints(REAL,INTEGER,INTEGER,INTEGER,INTEGER)-(o,i,i,i,i) language c

include	"readext.pro"
include	"dbase3.pro"

PREDICATES
  /* Listning of the database */
  list_recl(FldNameL,Dbase3RecL)
  list_rec(FldNameL,Dbase3Rec)
  list_elem(Dbase3Elem)
  NoofNL(Integer)
  PressAKey
  doPrompt

CLAUSES

/*************************************************************
		List Data from a .DBF & .DBT
*************************************************************/

  list_recL(_,[]) :- !.
  list_recL(FldNameL,[Rec|RecL]) :-
	nl,nl,
	list_rec(FldNameL,Rec), PressAkey,
	list_recL(FldNameL,RecL).

  list_rec([],[]) :- !.
  list_rec([FldName|FldNames],[Elem|Elems]) :-
	writef("\n%-12: ",FldName),
	list_elem(Elem),
	list_rec(FldNames,Elems).

  list_elem(char(Str))  :- write(Str).
  list_elem(real(Real)) :- write(Real).
  list_elem(logical(CH)):- write(CH).
  list_elem(memo(Str))  :- write(Str).
  list_elem(date(Date)) :- write(Date).

  NoofNL(N) :- N<=0,!.
  NoofNL(N) :- nl, N2=N-1, NoofNL(N2).

  PressAKey :-
	makewindow(_,_,_,_,MinR,_,NoofR,_),
	cursor(R,_), R<=MinR+NoofR-8,!.

  PressAKey :- doPrompt,cursor(R,C), scroll(R,0),cursor(0,C).

  doPrompt:-
	makewindow(Nr,Att,_,_,MinR,MinC,NoofR,NoofC),
	MinR2=MinR+NoofR-1, MinC2=MinC+NoofC/3+1,
	str_len(" Press a key",Len), Len2=Len+1, bitxor(Att,8,Att2),
	makewindow(Nr,Att2,0,"",MinR2,MinC2,1,Len2),
	write(" Press a key"), 
	readdevice(FP), readdevice(keyboard), readchar(_), readdevice(FP),
	removewindow.
	

/*************************************************************
		Goal
*************************************************************/
		
goal	openread(fp,"xdbase3.dbf"), filemode(fp,0), readdevice(fp),
	openread(mfp,"xdbase3.dbt"),filemode(mfp,0),

	/* Build data structure */
	init_dbase3(TotRecs,FldNameL,FldDescL),
	/* Remember file positions */
	filepos(fp,Fposfp,0), filepos(mfp,Fposmfp,0),
	
	/* Read all data records */
	rd_Dbase3File(TotRecs,mfp,FldDescL,RecL),

	/* List all records */
	makewindow(85,41,36," dBASE III(TM) All Data Records ",0,0,25,40),
	list_recL(FldNameL,RecL), DoPrompt,
	window_attr(27),
	
	/* Read records one by one */
	filepos(fp,Fposfp,0), filepos(mfp,Fposmfp,0),
	makewindow(85,72,33," dBASE III(TM) Sequential Access ",0,40,25,40),
	rd_Dbase3Rec(TotRecs,mfp,FldDescL,Rec),
	list_recL(FldNameL,[Rec]),fail.
