/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Demo of	color setting for ega adapter
****************************************************************/

include "tdoms.pro"
include "gdoms.pro"

domains
  file=datafile

database
  color(integer,integer)
  actualcolor(integer)

include "tpreds.pro"
include "gpreds.pro"
include "gega.pro"

predicates
  test(integer)
  choice(key)
  changecolor(integer)
  shiftcolor(color)
  getColorList(integerlist)
  showfield(integer)
  loop
clauses
  /* Default settings of the EGA palette registers */
  color(0,0).
  color(1,1).
  color(2,2).
  color(3,3).
  color(4,4).
  color(5,5).
  color(6,6).
  color(7,7).
  color(8,56).
  color(9,57).
  color(10,58).
  color(11,59).
  color(12,60).
  color(13,61).
  color(14,62).
  color(15,63).
  color(16,0).


  test(17):-!.
  test(N):-
	str_int(S,N),
	concat("Color ",S,Sn),
	FieldROw=N+3,N_=N,
  	gwrite(FieldRow,20,Sn,N_,0),
  	N1=N+1,
  	test(N1).
   
   choice(up):-!,
   	shiftcolor(-1).
   choice(down):-!,
   	shiftcolor(1).
   choice(left):-!,
   	changecolor(-1).
   choice(right):-!,
   	changecolor(1).
   choice(char('s')):-!,
   	getColorList(L),
   	openwrite(datafile,"color.def"),
   	writedevice(datafile),
   	write(L),
   	closefile(datafile),
   	writedevice(screen).
   choice(_):-
	beep.

   shiftcolor(N):-
   	retract(actualcolor(C)),!,
   	NewC=abs(C+N+17) mod 17,
   	assertz(actualcolor(NewC)),!.
   
  changecolor(N):-
   	actualcolor(AC),
	retract(color(AC,Color)),!,
	NewColor=abs(Color+N+64) mod 64,
	assert(color(AC,NewColor)),!.
   
  getColorList([Bgrnd,C1,C2,C3,C4,C5,C6,C7,C8,C9,C10,C11,C12,C13,C14,C15,Border]):-
  	color(0,Bgrnd),
  	color(1,C1), color(2,C2), color(3,C3), color(4,C4),
  	color(5,C5), color(6,C6), color(7,C7), color(8,C8),
  	color(9,C9), color(10,C10), color(11,C11), color(12,C12),
  	color(13,C13), color(14,C14), color(15,C15),
  	color(16,Border),!.
  	
  showfield(0):-
  	color(0,Color),!,
  	attribute(1),write(" (Background) =",Color).
  showfield(16):-
  	color(16,COlor),!,
  	attribute(Color),write(" (Border) =",Color).
  showfield(N):-
	color(N,COlor),!,
	attribute(Color),
	write(" ---> ",Color).

loop:-
	actualcolor(OldAct),!,
	FieldRow=OldAct+3,
	cursor(FieldRow,40),
	showfield(OldAct),
	readkey(K),
	choice(K),
	actualcolor(Regno),!,
	color(Regno,Color),!,
	setEGAregister(Regno,COlor),
	cursor(FieldRow,40),
	write("                    "),
	fail.

goal
  graphics(5,1,1),
  gwrite(0,15,"DEFINITION OF THE 17 EGA-PALETTE REGISTERS",1,0),
  gwrite(2,20,"Register (0-16)",1,0),
  gwrite(2,40,"Color code (0-63)",1,0),
  assert(actualcolor(1)),
  getcolorlist(L),
  setEGApalette(L),
  test(1),
  gwrite(3,20,"Background",1,0),
  gwrite(19,20,"Border",1,0),
  cursor(21,2),
  attribute(1),write(" Use "),attribute(15),write("\24"),
  attribute(1),write(" or "),attribute(15),write("\25"),
  attribute(1),write(" cursor keys to select registers and "),
  attribute(15),write("\26"),
  attribute(1),write(" or "),
  attribute(15),write("\27"),
  attribute(1),write(" to change color."),
  cursor(22,2),write("Press "),attribute(15),write(s),
  attribute(1),write(" to save the defining 17 integers in the file \"color.def\"."),
  line(2400,0,2400,31999,1),
  line(2400,0,31999,0,1),
  line(31999,0,31999,31999,1),
  line(31999,31999,2400,31999,1),
  repeat,
  loop.

