/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Demo of	miscellaneous graphic functions
****************************************************************/

project "xgeometr"

include "tdoms.pro"
include "gdoms.pro"

database
	newsline(string)

include "gglobs.pro"
include "tpreds.pro"
include "gpreds.pro"

predicates
	message(string,string,string,string,string)
	wfs(char)
	wait(integer)
goal
	graphics(1,1,1),
	makewindow(1,6,6,"Geometric shapes",0,0,18,40),
        makewindow(3,7,0,"",18,0,6,40),
	makewindow(4,8,0,"SPACE BAR MESSAGE",24,5,1,20),

	message("This demo includes predicates which may",
		"be used to draw real art.","","",""),
	shiftwindow(1),
	LineShade(0,0,18000,18000,18000,1,1),
	LineShade(0,0,18000,18000,18000,3,0),
	LineShade(0,0,18000,18000,18000,0,2),
	LineShade(0,0,18000,18000,18000,2,3),
	LineShade(18000,18000,0,24000,0,1,0),
	wfs(_),
	message("The graphics predicates include pred-",
		"icates which draw different geometric",
		"shapes:  circles, ellipses, rectangles",
		"etc. Each may be colored and filled.",
		"Here are some examples:"),
	shiftwindow(1),
	box(2000,2000,10000,15000,2,3,1),
	box(7000,7000,11000,20000,1,2,1),
	box(8000,8000,9000,18000,1,1,1),
	ellipse(5000,5000,4000,0.5,1,2,1),
	ellipse(9000,12000,8000,1.4,4,4,0),
	sector(9000,21000,5000,2,240,300,1,1,1),
	sector(9000,21000,5000,2,300,360,2,2,1),
	sector(9000,21000,5000,2,0,60,3,3,1),
	wfs(_).

clauses
   newsline("Press the space bar to continue.   ").
   message(S1,S2,S3,S4,S5):-
   	shiftwindow(Old),shiftwindow(3),
   	clearwindow,
	attribute(1),write(S1,"\n"),
	attribute(2),write(S2,"\n"),
	attribute(3),write(S3,"\n"),
	attribute(1),write(S4,"\n"),
	attribute(2),write(S5,"\n"),
	shiftwindow(Old).
   
   wfs(C):- 
   	shiftwindow(4),
   	attribute(2),
   	newsline(S),field_str(0,0,20,S),
   	keypressed,readchar(C),!,
   	field_str(0,0,20," "),shiftwindow(3).
   wfs(C):-wait(2000),
   	retract(newsline(String)),!,
   	frontstr(1,String,F,Rest),
   	concat(Rest,F,New),
   	assertz(newsline(New)),
   	wfs(C).

   wait(0):-!. wait(N):-N1=N-1,wait(N1).
