/***************************************************************
     Prolog Toolbox
     (C) Copyright 1987 Borland International.
***************************************************************/

code=3000 include "c:tdoms.pro" include "c:gdoms.pro"

database
	Scale(ScaleNo,x,x,y,y)
	activeScale(ScaleNo)
	axes(integer,integer,integer,xmarker,ymarker,col,row,col,row)
	newsline(string)       /* used by this demo only */

include "gglobs.pro"
include "tpreds.pro"
include "gpreds.pro"
include "ggraph.pro"

predicates
	element(string,drawing)
	process(char)
	zoom(x,x,y,y)
	message(string,string,string,string,string)
	wfs(char)
	wait(integer)
	function(x)

goal
	retract(_),fail; /* clear the database, then continue */
	assert(newsline("Press  the  space  bar     ")),
	graphics(2,1,1),
	makewindow(1,11,1,"Window used for Graph 1",0,36,18,44),
        makewindow(2,12,1,"Window used for Graph 2",0,0,18,35),
	makewindow(3,13,1,"Events",18,0,7,80),
	makewindow(4,7,0,"SPACE BAR MESSAGE",24,30,1,20),

	message("The first graph is used for coordinates, which on the X-axis run from 0",
		"to 100 and on the Y-axis run from -100 to +100.  This is accomplished by",
		"defining a 'scale'. In this way the graph is automatically scaled to fit",
		"the actual window.",
		"\tdefineScale(1,0,100,-100,100)"),
	defineScale(1,0,100,-100,100),
	wfs(_),
	message("Now we can draw axes in the actual window corresponding to that scale:",
		"",
		"\tmakeAxes(1,Ano,Gno,marker(10,d,3),marker(10,d,4),1,1,1,1)",
		"",
		""),
	shiftwindow(1),
	removewindow,
	makewindow(1,11,0,"Graph 1",0,36,18,44),

	makeAxes(1, 		/* Axes pair 1*/
		 _,  	        /* Axes Window No */
		 GWindow,	/* Graphics Window No*/
		 marker(10,d,3),
		 marker(10,d,4),
		 2,		/* Left   */
		 3,		/* Bottom */
		 2,		/* Right  */
		 1),		/* Top    */
	wfs(_),
	message("The axes may be labeled. For example using:",
		"",
		"\taxisLabels(1,\"Length in cm\",\"Height in cm\")",
		"",
		""),
	axisLabels(1,"Length in mm","Height in cm"),
	wfs(_),
	message("Any output may be directed to the graphics window by:",
		"",
		"\tshiftwindow(GraphWindowNo)",
		"\t...draw function output....",
		""),
	shiftwindow(GWindow),
	function(0),
	wfs(_),
	message("Normal text can be written in the graph-area.",
		"",
		"\tshiftwindow(Gno),cursor(0,0),write(\"F(X)=100*cos(6.28*X/50)\"),",
		"",
		""),
	shiftwindow(GWindow),
	cursor(0,0),write("F(X)=100*cos(6.28*X/50)"),
	wfs(_),
	message("The markings of the axes may be modified. Notice, that the intervals are",
		"increased, and that exponential notation is used on the X-axis instead of",
		"decimal notation, due to the calls:",
		"",
		"\tmodifyAxes(1,marker(20,e,4),marker(15,d,4)), refreshAxes(1),"),
	modifyAxes(1,marker(20,e,5),marker(15,d,4)),
	refreshAxes(1),
	axisLabels(1,"Length in mm","Height in cm"),
	shiftwindow(GWindow),
	function(0),
	wfs(_),
	message("Window 2 is to be used for another graph - a drawing - which is drawn",
		"relative to a new coordinate system. This requires two calls:",
		"",
		"\tdefineScale(2,0,500,0,300)",
		"\tmakeAxes(2,_,GWindow2,marker(50,d,3),marker(20,d,3),1,1,2,1),"),
	shiftwindow(2),
	makewindow(2,12,0,"Graph 2",0,0,18,35),
	defineScale(2,0,500,0,300),
	makeAxes(2,_,GWindow2,marker(50,d,3),marker(20,d,3),1,1,2,1),
	element(carbody,E1),element(frontwindow,E2),
	element(frontdoor,E3),element(rearwindow,E4),
	element(light,E5),
	shiftwindow(Gwindow2),
	draw([d(1,E1),d(1,E2),d(1,E3),d(1,E4),d(1,E5)]),
	wfs(_),
	message("Text may be positioned according to scaled coordinates using scaleCursor:",
		"For example:",
		"",
		"\tscaleCursor(100,40),write(\"Ford T - Year 1942\")",
		""),
	shiftwindow(Gwindow2),
	scaleCursor(100,40),write("Ford T - Year 1942"),
	wfs(_),
	message("The following predicates use scaled coordinates: scaleCursor,scalePlot and",
		"scaleLine. As an example of their use we will shift back to the first graph",
		"and the corresponding coordinate system, and then draw a line. This may be",
		"performed by:",
		"\tshiftwindow(GWindow),shiftScale(1),scaleLine(0,0,100,0,1),"),
	shiftwindow(GWindow),shiftScale(1),scaleLine(0,0,100,0,1),
	wfs(_),
	message("Any drawing or graph may be modified by changing the scale.",
		"In this example it is used to make the car look more sporty.",
		"","\tdefineScale(3,0,400,0,400),",""),
	defineScale(3,0,500,0,900),
	modifyAxes(2,marker(50,d,3),marker(50,d,3)),
	refreshAxes(2),
	shiftwindow(Gwindow2),
	draw([d(1,E1),d(1,E2),d(1,E3),d(1,E4),d(1,E5)]),
	wfs(_),
	message("Changing the coordinate system may be used to ZOOM in or out.",
		"Notice the effect when pressing either + or -." ,
		"(Any of the keys  l,r,u,d,<,>  will cause an effect).",
		"",
		"Use Ctrl-Break to stop."),
	retract(newsline(_)),
	assert(newsline("Press  +  -  <  >  l  r  u   or  d.    ")),
	repeat,
	wfs(C),
	write(C),
	process(C),
	refreshAxes(2),
	shiftwindow(Gwindow2),
	draw([d(1,E1),d(1,E2),d(1,E3),d(1,E4),d(1,E5)]),
	fail.

clauses
  element(carbody,
 	[p(70,100),p(90,195),p(190,205),p(240,300),
	p(400,300),p(450,205),p(500,205),p(500,100),p(70,100)]).
  element(frontwindow,
	[p(243,290),p(320,290),p(320,210),p(200,210),p(243,290)]).
  element(frontdoor,
	[p(200,205),p(200,105),p(320,105),p(320,205),p(200,205)]).
  element(rearwindow,
 	[p(330,290),p(398,290),p(438,210),p(330,210),p(330,290)]).
  element(light,[p(85,165),p(93,165),p(98,196)]).

  process('+'):- zoom(0,-100,0,-60).	/*big*/
  process('-'):- zoom(0,100,0,60).	/*small*/
  process('l'):- zoom(50,50,0,0).	/*left*/
  process('r'):- zoom(-50,-50,0,0).	/*right*/
  process('u'):- zoom(0,0,-50,-50).	/*up*/
  process('d'):- zoom(0,0,50,50).	/*down*/
  process('w'):- zoom(0,-50,0,0).	/*wide*/
  process('t'):- zoom(0,0,0,-50).	/*tall*/
  process('<'):-
                activescale(N),!,
  		scale(N,X1,X2,_,_),!,
	 	L=X2-X1,H=X1-X2,
	 	zoom(L,H,0,0).
  process('>'):-
                activescale(N),!,
  		scale(N,_,_,Y1,Y2),!,
	  	L=Y2-Y1,H=Y1-Y2,
	  	zoom(0,0,L,H).

  zoom(Dxl,Dxh,Dyl,Dyh):-
	activescale(N),!,
	scale(N,Xmin,Xmax,Ymin,Ymax),!,
	NewXl=Xmin+Dxl,
	NewYl=Ymin+Dyl,
	NewXh=Xmax+Dxh,
	NewYh=Ymax+Dyh,
	NewXl<>NewXh,
	NewYl<>NewYh,!,
	retract(scale(N,_,_,_,_)),!,
	asserta(scale(N,NewXl,NewXh,NewYl,NewYh)).


   message(S1,S2,S3,S4,S5):-
   	shiftwindow(Old),shiftwindow(3),
   	clearwindow,write(S1,"\n",S2,"\n",S3,"\n",S4,"\n",S5),shiftwindow(Old).
   
   wfs(C):- 
   	shiftwindow(4),clearwindow,
   	newsline(S),field_str(0,0,20,S),
   	keypressed,readchar(C),!,shiftwindow(3).
   wfs(C):-wait(3000),
   	retract(newsline(String)),!,
   	frontstr(1,String,F,Rest),
   	concat(Rest,F,New),
   	assertz(newsline(New)),!,
   	wfs(C).

   wait(0):-!. wait(N):-N1=N-1,wait(N1).

   function(N):-N>100,!.
   function(N):-Y=100*cos(6.28*N/50),scalePlot(N,Y,1),N1=N+1,function(N1).
