/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Demo of	menu_mult
****************************************************************/

include "tdoms.pro"
include "tpreds.pro"
include "menu.pro"

DOMAINS
  numberlist=integer*

PREDICATES
  solution(integer,integerlist)
  ask(numberlist,integer)
  append(integerlist,integerlist,integerlist)
  member(integer,integerlist)
  q(integer,string,stringlist)
  same(integerlist,integerlist)
  allelts(integerlist,integerlist)
  message(integer)
  checkanswer(integer,integerlist,integerlist,integer)

GOAL
	makewindow(1,32,66,"Professor Blanketbrain's Intelligence Test",
								0,0,25,80),
	write("\n\n\tMake any number of selections using the RETURN key."),
	write("\n\tWhen all selections have been made, press F10."),
	nl,nl,ask([4,3,2,1],Totalok),
	nl,nl,write("    - The puzzle is over. "),nl,nl,
	message(Totalok),nl,nl,
	write("    Please press the space bar."),
	readchar(_).

CLAUSES
  q(1,"Question 1: Which animal(s) are the odd ones out?",
	[dog,cat,duck,rabbit,whale,swan]).

  q(2,"Question 2: Which number(s) are the odd ones out?",
	["2","3","4","5","6","7" ]).

  q(3,"Question 3: Which colors are the odd ones out?",
	[red,orange,yellow,pink,green,brown,black]).

  q(4,"Question 4: Which name(s) are the odd ones out?",
	[kim,tom,george,alison,mary,martha]).

  solution(1,[3,6]).
  solution(2,[3,5]).
  solution(3,[4,6,7]).
  solution(4,[1,2]).

  message(4):-
	write("    You got all 4 correct."),nl,
	write("    Professor Blanketbrain thinks you are a genius.").

  message(0):-
	write("    You got none of them correct."),nl,
	write("    Professor Blanketbrain thinks you could improve your knowledge.").

  message(Totalok):-
	write("     You got ",Totalok," correct. "),nl,
	write("    Not bad but not good either.").

  ask([],0).
  ask([X | Y],Newscore):-
	ask(Y,Oldscore),q(X,Title,Choicelist),
	menu_mult(10,10,7,23,Choicelist,Title,[],Oddlist),
	solution(X,L),checkanswer(X,L,Oddlist,Score),
	Newscore=Oldscore+Score.
              
  checkanswer(X,L,Oddlist,1):-
	same(L,Oddlist),
	write("     You have got question  ",X),
	write(" correct. Please press the space bar."),
	nl,readchar(_).
  checkanswer(X,_,_,0):-
	write("    Sorry, but you have got question ",X),
	write(" wrong  - Please press the space bar."),
	nl,readchar(_).
     
  same(A,B):-allelts(A,B),allelts(B,A).

  allelts([],_).
  allelts([X | Y],B):-member(X,B),allelts(Y,B).

  member(X,[X|_]).
  member(X,[_|Y]):-member(X,Y).
         
  append([],X,X).
  append([X|L1],L2,[X|L3]):-append(L1,L2,L3).
