/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Label printing
****************************************************************/

code=2500

include "tdoms.pro"

DOMAINS
  FNAME=SYMBOL
  TYPE = int(); str(); real()
  FILE = myprinter

DATABASE
  /* Database declarations used in SCRHND.PRO */
  insmode			/* Global insertmode */
  actfield(FNAME)		/* Actual field */
  screen(SYMBOL,DBASEDOM)	/* Saving different screens */
  value(FNAME,STRING)		/* value of a field */
  field(FNAME,TYPE,ROW,COL,LEN) /* Screen definition */
  txtfield(ROW,COL,LEN,STRING)
  windowsize(ROW,COL).
  notopline

  /* Database declarations used in VSCRHND.PRO */
  windowstart(ROW,COL)
  mycursord(ROW,COL)

  /* Database declarations used in LINEINP.PRO */
  lineinpstate(STRING,COL)
  lineinpflag

  label(STRING)
  dbstrike
  font(INTEGER)
  printer(STRING)

include "status.pro"
include "tpreds.pro"
include "menu.pro"
include "lineinp.pro"
include "filename.pro"
include "scrhnd.pro"

/*******************************************************************
		Internal Predicates
*******************************************************************/

PREDICATES
  displbl
  printlabels
  change(DBASEDOM)
  filename(STRING)
  rdfile(STRING,STRING)
  index(INTEGER,STRINGLIST,STRING)
  nondeterm fonttext(INTEGER,STRING)
  nondeterm printers(STRING)
  nondeterm member(STRING,STRINGLIST)
  nondeterm for(INTEGER,INTEGER,INTEGER)
  write_n(INTEGER,CHAR)
  str_lines(STRING,STRINGLIST)
  setprintercodes
  printlabel(STRINGLIST)
  printercode(STRING)

CLAUSES
  change(value(X,_)):-retract(value(X,_)),fail.
  change(label(_)):-retract(label(_)),fail.
  change(font(_)):-retract(font(_)),fail.
  change(printer(_)):-retract(printer(_)),fail.
  change(label(LBL)):-!,assert(label(LBL)),displbl.
  change(X):-assert(X).

  displbl:-
	label(LBL),!,
	shiftwindow(5),
	window_str(LBL),
	shiftwindow(1).

  filename(FILENAME):-
	value(file,FNAME),!,
	cursor(ROW,COL),R1=ROW+2,
	readfilename(R1,COL,23,23,lbl,FNAME,FILENAME),
	change(value(file,FILENAME)).

  rdfile(FILENAME,LABEL):-
	file_str(FILENAME,LABEL),!.
  rdfile(FILENAME,_):-
  	makewindow(1,23,23,"",5,20,4,45),
	write(">> File not found: ",FILENAME),
	readkey(_),removewindow,fail.

  fonttext(1,"Fast").  fonttext(2,"Medium").  fonttext(3,"Quality").

  printers(prn).  printers(com1).  printers(com2).

  printlabels:-
	label(LBL),str_lines(LBL,LIST),
	printer(PRINTER),
	value(number,NN),str_int(NN,NOOFLABELS),
	openwrite(myprinter,PRINTER),
	writedevice(myprinter),
	setprintercodes,
	for(I,0,NOOFLABELS),
	printlabel(LIST),
	I>=NOOFLABELS-1,!,
	closefile(myprinter).

  printlabel(LIST):-
	value(indent,NN),str_int(NN,N),
	member(LINE,LIST),
	write_n(N,' '),write(LINE),nl,
	fail.
  printlabel(LIST):-
	listlen(LIST,LEN),
	value(labellines,TT),str_int(TT,TOT),!,
	SKIP=TOT-LEN,
	write_n(SKIP,'\n').

  setprintercodes:-
	value(initcode,INIT),
	printercode(INIT),fail.
  setprintercodes:-
	dbstrike,
	value(dbstrikecode,DBSTRIKE),
	printercode(DBSTRIKE),fail.
  setprintercodes:-
	font(N),str_int(NO,N),
	concat("font",NO,FRONT),
	value(FRONT,FRONTCODE),
	printercode(FRONTCODE),fail.
  setprintercodes.

  printercode(""):-!.
  printercode(CODE):-
	frontchar(CODE,'\\',REST),
	fronttoken(REST,NUM,RESTCODE),
	str_int(NUM,CHI),
	char_int(CH,CHI),
	write(CH),!,
	printercode(RESTCODE).
  printercode(CODE):-
	frontchar(CODE,CH,REST),
	write(CH),
	printercode(REST).

  index(1,[H|_],H):-!.
  index(N,[_|T],X):-N>1,N1=N-1,index(N1,T,X).

  member(X,[X|_]).
  member(X,[_|L]):-member(X,L).

  for(I,I,_).
  for(I,A,B):-B>A,A1=A+1,for(I,A1,B).

  write_n(0,_):-!.
  write_n(N,CH):-N>0,write(CH),N1=N-1,write_n(N1,CH).

  str_lines("",[]):-!.
  str_lines(STR,[H|T]):-
	search_char('\n',STR,0,N),
	frontstr(N,STR,H,R),
	frontchar(R,_,R1),!,
	str_lines(R1,T).
  str_lines(STR,[STR]).


/****************************************************************
		Screen handling predicates
****************************************************************/

  noinput(load).	noinput(save).		noinput(saveconfig).
  noinput(print).	noinput(printer).	noinput(font).
  noinput(edit).	noinput(dir).		noinput(dbstrike).

  field_action(load):-
	cursor(ROW,COL),R1=ROW+2,
	readfilename(R1,COL,23,23,lbl,"",FILENAME),
	rdfile(FILENAME,LABEL),
	change(value(file,FILENAME)),
	change(label(LABEL)).
  field_action(save):-
	filename(FILENAME),
	label(LABEL),!,
	file_str(FILENAME,LABEL).
  field_action(edit):-
	label(LABEL),
	shiftwindow(5),
	editmsg(LABEL,LABEL1,"edit","","",0,"",RET), 
	shiftwindow(1),
	refreshstatus,
	RET><1,!,
	change(label(LABEL1)).
  field_action(edit):-displbl.
  field_action(dir):-cursor(ROW,COL),setdir(ROW,COL,23,23).
  field_action(file):-filename(_).
  field_action(print):-printlabels.
  field_action(dbstrike):-retract(dbstrike),!.
  field_action(dbstrike):-assert(dbstrike).
  field_action(font):-
	cursor(ROW,COL),
	findall(X,fonttext(_,X),LIST),
	menu(ROW,COL,23,23,LIST,"Choose font",0,FRONT),
	FRONT><0,
	change(font(FRONT)).
  field_action(printer):-
	cursor(ROW,COL),
	findall(X,printers(X),LIST),
	menu(ROW,COL,23,23,LIST,"Choose printer",0,NR),
	index(NR,LIST,PRINTER),
	change(printer(PRINTER)).
  field_action(saveconfig):-save("xlabel.dba").

  field_value(dir,DISK):-!,disk(DISK).
  field_value(dbstrike,on):-dbstrike,!.
  field_value(dbstrike,off):-!.
  field_value(font,FRONT):-!,font(NR),fonttext(NR,FRONT),!.
  field_value(printer,X):-!,printer(X),!.
  field_value(FNAME,VAL):-value(FNAME,VAL),!.

GOAL	makewindow(5,66,67,"LABEL",15,0,9,80),
	makewindow(1,32,33,"Label Printing",0,0,15,80),
	makestatus(23," Move the cursor with the arrow keys and select by pressing RETURN"),
	consult("xlabel.dba"),
	displbl,
	scrhnd(off,_).

