/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Demo of	lineinput utility
****************************************************************/

include "tdoms.pro"

DATABASE
  insmode
  lineinpstate(STRING,COL)
  lineinpflag

CLAUSES
  insmode.

include "tpreds.pro"
include "lineinp.pro"
include "status.pro"

PREDICATES
  test

CLAUSES
  test:-
	lineinput(10,10,45,23,66,"Which computer do you have: ","IBM PC",TXT),
	write("Resulting text input: ",TXT),nl,fail.

  test:-
	changestatus(" Modify each of the three texts, pressing Cr after each"),
	lineinput_leave(7,10,40,23,71,"Text1: ","this is old text 1",TXT1),
	lineinput_leave(11,10,40,23,71,"Text2: ","this is old text 2",TXT2),
	lineinput_leave(15,10,40,23,71,"Text3: ","this is old text 3",TXT3),
	removewindow,removewindow,removewindow,
	write("TEXT1= ",TXT1),nl,
	write("TEXT2= ",TXT2),nl,
	write("TEXT3= ",TXT3),nl,
	fail.

  test:-
	changestatus("Press the space bar for a demo of lineinput_repeat"),
	readkey(_),
	clearwindow,
	changestatus(" Lineinput_repeat requests for new lines until the Esc key is pressed."),
	lineinput_repeat(7,10,40,23,71,"Text: ","",TXT),
	shiftwindow(OLD),
	shiftwindow(2),
	write("TEXT= ",TXT),nl,
	shiftwindow(OLD),
	fail.

  test.

GOAL
	makewindow(2,32,0,"",0,0,24,80),
	makestatus(112," Input some new text or amend the old"),
	test,
	changestatus("End of demo").
