/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Demo of	longmenu
****************************************************************/

include "tdoms.pro"
include "tpreds.pro"
include "longmenu.pro"
include "status.pro"

Predicates
  test
  for(INTEGER,INTEGER,INTEGER)
  str(STRING)

CLAUSES
  for(X,X,_).
  for(I,A,B):-B>A,A1=A+1,for(I,A1,B).

  str(first).
  str(second).
  str(third).
  str(S):-for(I,4,50),str_int(S,I).

  test:-
	changestatus("Lmenu is used to select from more than 23 alternatives    Cr:Select    Esc:abort"),
	findall(X,str(X),L),
	longmenu(10,10,5,7,66,L,"longmenu",10,CHOICE),
	write("Last time you chose: ",CHOICE),nl,fail.

  test:-
	changestatus("longmenu with pre-selected starting point for the cursor   Cr:Select    Esc:abort"),
	findall(X,str(X),L),
	longmenu(10,10,5,7,66,L,"longmenu",3,CHOICE),
	write("Last time you chose: ",CHOICE),nl,fail.

  test:-
	changestatus("Using longmenu to create an unframed menu    Cr:Select    Esc:abort"),
	findall(X,str(X),L),
	longmenu(10,10,5,112,0,L,"This message will not be visible",20,CHOICE),
	write("Last time you chose: ",CHOICE),nl,fail.

  test:-
	changestatus("Lmenu_leave: make one selection from each menu displayed  Cr:Select Esc:abort"),
	findall(X,str(X),L),
	longmenu_leave(5,0,5,7,66,L,first,1,CH1),
	longmenu_leave(10,20,5,7,71,L,second,22,CH2),
	longmenu_leave(15,40,5,7,36,L,third,33,CH3),
	removewindow,removewindow,removewindow,
	write("Last time you chose: ",CH1,", ",CH2,", ",CH3),nl,fail.

  test:-
	changestatus("Longmenu_mult allows multiple selections  F10:End Cr:(Un) select  Esc:abort"),
	findall(X,str(X),L),
	longmenu_mult(10,10,5,7,66,L,"test",[2],CHOICEL),
	write("Last time you chose: ",CHOICEL),nl,fail.
  test.

GOAL
	makewindow(1,23,0,"test",0,0,24,80),
	write("Use cursor keys to inspect the rest of the menu items\n\n"),
	makestatus(112,"Choose a number"),
	test,
	changestatus("End of demo").
