/************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

	Access a Lotus 1-2-3(TM) & Symphony(TM) compatible file
	from Prolog.
	
	We are using the file "XLOTUS.WRK" for this demo program.

*************************************************************/

project "xlotus"

Domains
  File	= fp

global predicates
  real_ints(REAL,INTEGER,INTEGER,INTEGER,INTEGER)-(o,i,i,i,i) language c

include	"readext.pro"
include	"lotus.pro"

PREDICATES
  /* Listning */
  list_Recs(Integer,LotusRecL)
  list_Rec(Integer,Integer,LotusRec)
  wr_Version(Integer)
  wr_elem(Value)
  NoofNL(Integer)
  PressAKey
  doPrompt

CLAUSES
  list_Recs(_,[]):- !.
  list_Recs(CurRow,[Rec|RecL]):-
	list_rec(CurRow,CurRow2,Rec),
	list_Recs(CurRow2,RecL).

  list_rec(CurRow,CurRow,elem(CurRow,Col,Int)) :- !,
	cursor(Row,_), Col2=Col*8, cursor(Row,Col2), wr_elem(Int).

  list_rec(CurRow,Row,elem(Row,Col,Int)) :- !,
	NL = Row-CurRow,
	NoofNL(NL), Col2=Col*8,
	cursor(Row2,_), cursor(Row2,Col2), wr_elem(Int).

  list_rec(CurRow,CurRow,version(V)):-
	write("\t\tVersion: "),wr_Version(V).


  wr_Version(1028) :- write("Lotus 1-2-3(TM) 1.0\n").
  wr_Version(1029) :- write("Symphony(TM) 1.0\n").
  wr_Version(1030) :- write("Lotus 1-2-3(TM) 2.0  or  Symphony(TM) 1.1\n").

  wr_elem(int(I))  :- writef("%8",I).
  wr_elem(real(I)) :- writef("%8",I).
  wr_elem(label(S)):- writef("%8",S).

  NoofNL(N) :- N<=0,!.
  NoofNL(N) :- nl, N2=N-1, NoofNL(N2).


  PressAKey :-
	makewindow(_,_,_,_,MinR,_,NoofR,_),
	cursor(R,_), R<=MinR+NoofR-4,!.
  PressAKey :- doPrompt,cursor(R,C), scroll(R,0),cursor(0,C).

  doPrompt:-
	makewindow(Nr,Att,_,_,MinR,MinC,NoofR,NoofC),
	MinR2=MinR+NoofR-1, MinC2=MinC+NoofC/3+1,
	str_len(" Press a key",Len), Len2=Len+1, bitxor(Att,8,Att2),
	makewindow(Nr,Att2,0,"",MinR2,MinC2,1,Len2),
	write(" Press a key"), 
	readdevice(FP), readdevice(keyboard), readchar(_), readdevice(FP),
	removewindow.
	

/*************************************************************
		Goal
*************************************************************/
 		
GOAL	openread(fp,"xlotus.wrk"), readdevice(fp), filemode(fp,0),
	
	/* Read all records at once */
	rd_LotusFile(RecL),
	makewindow(85,40,36," Lotus 1-2-3 (TM)& Symphony (TM) - All Records ",0,0,25,80),
	write("\n\n",RecL), doPrompt,

	/* Read sequentially, searching for specific record */
	filepos(fp,0,0),
	write("\n\nSearch for a record at column 0"),
	rd_Lotuscell(elem(Row,0,R)), Elem1=elem(Row,0,R),
	write(", Record: ",Elem1),

	write("\n\nSearch for a record at row 3 and column 3"),
	rd_Lotuscell(elem(3,3,R2)), Elem2=elem(3,3,R2),
	write(", Record: ",Elem2),
	doPrompt,

	/* List records in "Spreadsheet" way */
	makewindow(85,26,36," Lotus 1-2-3 (TM)& Symphony (TM) ",0,0,25,80),
	cursor(Xa,Ya),nl,nl,
	list_recs(0,RecL), doPrompt.
