/***************************************************************
     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.
***************************************************************/


code=4000
include "tdoms.pro"

DOMAINS
  CURSOR = INTEGER
  PROCID = STRING

DATABASE
  source(STRING)
  filename(STRING)
  pdwstate(ROW,COL,SYMBOL,ROW,COL)
  insmode
  lineinpstate(STRING,COL)
  lineinpflag
  error(STRING,CURSOR)

include "tpreds.pro"
include "status.pro"
include "pulldown.pro"
include "lineinp.pro"
include "filename.pro"

include "xminigol.dom"

PREDICATES
  scan_error(STRING,CURSOR)

include "xminigol.sca"

PREDICATES
  strlist_str(STRINGLIST,STRING)
  ed(STRING,CURSOR)
  change(DBASEDOM)
  resetflags
  nondeterm repparse
  parse
  better_error(CURSOR)
  new_error(STRING,CURSOR)

PREDICATES
  expect(CURSORTOK,TOKL,TOKL)
  syntax_error(STRING,TOKL)
  checkempty(TOKL)

include "xminigol.par"

CLAUSES
  better_error(CURSOR):-
	error(_,OLDCURSOR),OLDCURSOR>=CURSOR,!,fail.
  better_error(_).

  new_error(_,_):-retract(error(_,_)),fail.
  new_error(MSG,CURSOR):-assert(error(MSG,CURSOR)).

  expect(TOK,[TOK|L],L):-!.
  expect(t(TOK,_),[t(_,CURSOR)|_],_):-
	better_error(CURSOR),
	str_tok(STR,TOK),
	concat(STR," expected",MSG),
	new_error(MSG,CURSOR),fail.

  syntax_error(PROD,[t(_,CURSOR)|_]):-
	better_error(CURSOR),
	concat("Syntax error in ",PROD,MSG),
	new_error(MSG,CURSOR),fail.

  scan_error(MSG,CURSOR):-ed(MSG,CURSOR),fail.

  checkempty([]):-!.
  checkempty([t(_,CURSOR)|_]):-
	better_error(CURSOR),
	new_error("Syntax error",CURSOR).

  strlist_str([],"").
  strlist_str([H|T],STR):-
	concat(H," ",H1),
	strlist_str(T,STR1),
	concat(H1,STR1,STR).

  ed(MSG,CURSOR):-
	source(TXT),
	editmsg(TXT,TXT1,"","",MSG,CURSOR,"",RET),
	RET><1,!,
	change(source(TXT1)).

  resetflags:-retract(error(_,_)),fail.
  resetflags.

  change(source(_)):-retract(source(_)),fail.
  change(filename(_)):-retract(filename(_)),fail.
  change(X):-assert(X).

  repparse.
  repparse:-error(MSG,CURSOR),ed(MSG,CURSOR),!,repparse.


  parse:-
	repparse,
	resetflags,
	source(STR1),
	tokl(0,STR1,L),
	s_sent(L,L1,X),
	checkempty(L1),!,
	makewindow(2,23,23,"",0,0,25,80),
	write(X),
	readkey(_),
	removewindow.
  parse:-
	write(">> Parsing aborted"),nl,beep.

  pdwaction(1,0):-
	shiftwindow(OLD),shiftwindow(1),
	parse,
	shiftwindow(OLD),
	refreshstatus.
  pdwaction(2,0):-
	shiftwindow(OLD),shiftwindow(1),
	source(TXT),
	editmsg(TXT,TXT1,"","","",0,"",RET),
	shiftwindow(OLD),
	RET><1,!,
	change(source(TXT1)),
	refreshstatus.
  pdwaction(2,0):-refreshstatus.
  pdwaction(3,1):-
	readfilename(5,40,66,66,txt,"",NEW),
	change(filename(NEW)),
	file_str(NEW,NEWSOURCE),!,
	change(source(NEWSOURCE)),
	shiftwindow(OLDW),
	shiftwindow(1),
	window_str(NEWSOURCE),
	shiftwindow(OLDW),
	refreshstatus.
  pdwaction(3,1).
  pdwaction(3,2):-
	source(SOURCE),
	filename(OLD),
	readfilename(5,40,66,66,txt,OLD,NEW),
	change(filename(NEW)),
	file_str(NEW,SOURCE),
	refreshstatus,!.
  pdwaction(3,2).
  pdwaction(3,3):-setdir(5,40,66,66).
  pdwaction(4,0):-
	lineinput(5,70,40,66,66,"Are you sure (y/n) ? ","",ANS),
	upper_lower(ANS,ANS1),
	ANS1><"y".


  filename("minigol.txt").
  source("").

GOAL

/*
          1         2         3         4         5         6         7
01234567890123456789012345678901234567890123456789012345678901234567890123456789
       COMPILE            EDIT              FILES               QUIT
*/
  makewindow(1,23,23,"Edit",3,0,21,80),
  makestatus(112," Select with arrows or use first upper case letter"),
  pulldown(66,
	  [ curtain(7,"Compile",[]),
	    curtain(26,"Edit",[]),
	    curtain(44,"Files",["Load","Save","Dir"]),
            curtain(64,"Quit"      ,[])
          ],_,_).


