/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Demo of	piechart
****************************************************************/

project "xpie"

include "tdoms.pro"
include "gdoms.pro"

database
	newsline(string)

include "gglobs.pro"
include "tpreds.pro"
include "gpreds.pro"
include "gpie.pro"

predicates
	message(string,string,string,string,string)
	wfs(char)
	wait(integer)


goal
	assert(newsline("Press the space bar to continue.   ")),
	graphics(1,1,1),
	makewindow(1,6,0,"",0,0,18,40),
	makewindow(3,7,0,"",18,0,6,40),
	makewindow(4,8,0,"SPACE BAR MESSAGE",24,5,1,20),
	message("PIECHARTS are easily drawn by giving",
		"the CENTER and RADIUS of the", 
                "piechart and the PERCENTAGE,",
		"FRAMECOLOR, FILLCOLOR and",
		"LABEL for each slice in the pie."),
	shiftwindow(1),	
	pieChart(11000,19000,6000,
		     [slice(10.6,"January",1,2),
		      slice(20.7,"February",2,3),
		      slice(15.1,"March",3,2),
		      slice(23.5,"April",1,3),
		      slice(5,"June",2,1),
			      slice(17,"July",3,2)]),
	wfs(_),
	message("To attach an explanatory text to",
		"a pie chart you can use",
		"the gwrite tool predicate.",
		"",
		""),
	shiftwindow(1),
	gwrite(0,5,"SALES THE FIRST SIX MONTHS IN 1987",3,0),
	gwrite(5,0,"EVALUATION:",1,0),
	gwrite(6,0,"------------",1,0),
	gwrite(8,0,"\219 = good",3,0),
	gwrite(10,0,"\219 = average",2,0),
	gwrite(12,0,"\219 = bad",1,0),
	gwrite(14,0,"------------",1,0),
	wfs(_),
	message("If certain slices need special",
		"attention they may be moved outwards",
		"and their labels may be suffixed with",
		"a percentage.",
		""),
	shiftwindow(1),
	clearwindow,
	pieChart(11000,19000,6000,
		     [slice(10.6,"January",1,2),
		      slice(-20.7,"February=",2,3),
		      slice(15.1,"March",3,2),
		      slice(-23.5,"April=",1,3),
		      slice(5,"June",2,1),
		      slice(17,"July",3,2)]),
	gwrite(0,5,"SALES THE FIRST SIX MONTHS IN 1987",3,0),
	gwrite(4,0,"EVALUATION:",3,0),
	gwrite(6,0,"------------",1,0),
	gwrite(8,0,"\219 = good",3,0),
	gwrite(10,0,"\219 = average",2,0),
	gwrite(12,0,"\219 = bad",1,0),
	gwrite(14,0,"------------",1,0),
	wfs(_),
	message("Two small piecharts may be ",
		"used for comparing different periods.",
		"",
		"",
		""),
	shiftwindow(1),
	clearwindow,
	pieChart(15000,7000,3000,
		     [slice(10.6,"Jan",1,2),
		      slice(20.7,"Feb",2,3),
		      slice(15.1,"Mar",3,2),
		      slice(17,"Apr",2,1)]),
	pieChart(15000,20000,3000,
		     [slice(16,"May",1,2),
		      slice(10.7,"Jun",2,3),
		      slice(15.1,"Jul",3,2),
		      slice(6,"Aug",2,1)]),
	wfs(_),
	message("The next demo requires an EGA card.",
		"16 colors are used to distinguish",
		"the different slices.",
		"Press E if the EGA card is attached",
                "otherwise press the space bar"),
		
	retract(newsline(_)),
	assert(newsline("Press E when using EGA-card  ")),
	wfs(Key),!,
	str_char(K,Key),
	upper_lower(K,"e"),
	graphics(4,1,1),
	makewindow(1,6,0,"",0,0,18,80),
	makewindow(3,7,0,"",18,0,6,80),
	makewindow(4,8,0,"SPACE BAR MESSAGE",24,30,1,20),
	message("Piechart using EGA mode with 640 x 200 pixels in 16 colors",
		"",
		"",
		"",
		""),
	shiftwindow(1),	
	gwrite(0,0,"SALES JANUARY 1986 - MARCH 1987",1,0),
	gwrite(3,0,"Colors of the two best months:",1,0),
	gwrite(5,10,"\219",7,0),
	gwrite(7,10,"\219",10,0),

	pieChart(11000,20000,6500,
		     [slice(5,"Jan86",1,1),
		      slice(7,"Feb86",2,2),
		      slice(8,"Mar86",3,3),
		      slice(5,"Apr86",4,4),
		      slice(6,"May86",5,5),
		      slice(6,"Jun86",6,6),
		      slice(-9,"Jul86=",7,7),
		      slice(4,"Aug86",8,8),
		      slice(8,"Sep86",9,9),
		      slice(-9,"Oct86=",10,10),
		      slice(6,"Nov86",11,11),
		      slice(3,"Dec86",12,12),
		      slice(5,"Jan87",13,13),
		      slice(7,"Feb87",14,14),
		      slice(3,"Mar87",15,15)]),
	retract(newsline(_)),
	assert(newsline("Press the SPACE BAR to continue. ")),
	wfs(_),
	graphics(5,1,1),
	makewindow(1,6,0,"",0,0,18,80),
	makewindow(3,7,0,"",18,0,6,80),
	makewindow(4,8,0,"SPACE BAR MESSAGE",24,30,1,20),
	message("EGA supports 640 x 350 pixel resolution in 16 colors",
		"Higher resolution implies a decrease in speed.",
		"",
		"",
		""),
	shiftwindow(1),
	gwrite(0,0,"SALES JANUARY 1986 - MARCH 1987",1,0),
	gwrite(3,0,"The two best months:",1,0),
	gwrite(5,5,"Jul86  \219",7,0),
	gwrite(7,5,"Oct86  \219",10,0),

	pieChart(11000,20000,6000,
		     [slice(5,"Jan86",1,1),
		      slice(7,"Feb86",2,2),
		      slice(8,"Mar86",3,3),
		      slice(5,"Apr86",4,4),
		      slice(6,"May86",5,5),
		      slice(6,"Jun86",6,6),
		      slice(-9,"Jul86=",7,7),
		      slice(4,"Aug86",8,8),
		      slice(8,"Sep86",9,9),
		      slice(-9,"Oct86=",10,10),
		      slice(6,"Nov86",11,11),
		      slice(3,"Dec86",12,12),
		      slice(5,"Jan87",13,13),
		      slice(7,"Feb87",14,14),
		      slice(3,"Mar87",15,15)]),
	wfs(_).


clauses
   message(S1,S2,S3,S4,S5):-
   	shiftwindow(Old),shiftwindow(3),
   	clearwindow,
	attribute(1),write(S1,"\n"),
	attribute(2),write(S2,"\n"),
	attribute(1),write(S3,"\n"),
	attribute(2),write(S4,"\n"),
	attribute(1),write(S5,"\n"),
	shiftwindow(Old).
   
   wfs(C):- 
   	shiftwindow(4),clearwindow,
	attribute(1),
   	newsline(S),field_str(0,0,20,S),
   	keypressed,readchar(C),!,shiftwindow(3).

   wfs(C):-wait(8000),
   	retract(newsline(String)),!,
   	frontstr(1,String,F,Rest),
   	concat(Rest,F,New),
   	assertz(newsline(New)),
   	wfs(C).

   wait(0):-!. wait(N):-N1=N-1,wait(N1).
