/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

	Demo of polled transmission with 'time out'
****************************************************************/

Project "xpolling"

DOMAINS
  FILE = df

include "tdoms.pro"
include "comglobs.pro"
include "tpreds.pro"
include "menu.pro"
 
PREDICATES
  send_str(STRING)
  send_ch_CRLF(CHAR,INTEGER)
  send_ch(CHAR,INTEGER)
  receive_str()
  receive_ch(CHAR,INTEGER)
  wait_ok(INTEGER,INTEGER,INTEGER)
  tx_status(INTEGER)
  check_status(INTEGER,INTEGER,STRING)

GOAL
	openRS232(1,256,256,7,0,3,0,2),
	makewindow(3,7,7,"Output Window",0,0,10,80),
	send_str("Hello to all our readers.\n"),
	write("Press any key"),
	readchar(_),
	closeRS232(1).

CLAUSES
  /* Transmit a string  */
  send_str(""):-!.
  send_str(S):-frontchar(S,CH,S2),
		 write(CH), send_ch_CRLF(CH,50),
	         send_str(S2).

  send_ch_CRLF('\10',I):-!,send_ch('\13',I), send_ch('\10',I).
  send_ch_CRLF(CH,I):-send_ch(CH,I).

  send_ch(CH,_):-txch_RS232(1,CH),!.
  send_ch(CH,I):-
	status_RS232(1,Status),!,
	wait_ok(Status,I,I2), send_ch(CH,I2).

  /* Receive a string and copy it to a file */
  receive_str():-
	receive_ch(CH,50),!,
	write(CH),
	writedevice(FP), writedevice(df), write(CH), writedevice(FP),
  	receive_str().
  receive_str().

  receive_ch(CH,_):-rxch_RS232(1,CH), CH<>'\013', !.
  receive_ch(CH,_):-rxch_RS232(1,CH), !.
  receive_ch(CH,I):-
	status_RS232(1,Status), !,
	wait_ok(Status,I,I2), receive_ch(CH,I2).

  /* Time out */
  wait_ok(_,I,I2):-I > 0, I2=I-1,ticks(10),!.
  wait_ok(Status,_,50):-tx_status(Status).

  /* De-mask status value */
  tx_status(0):-!.
  tx_status(Status):-
  	shiftwindow(WD), shiftwindow(1),
  	check_status(Status,1, "Input Characters have beenlost"),
  	check_status(Status,2,  "Parity Error"),
  	check_status(Status,4,  "Overrun detected"),
  	check_status(Status,8,  "Framing error detected"),
  	check_status(Status,16, "Break signal detected"),
  	check_status(Status,32, "An Xoff has been received"),
  	check_status(Status,64, "An Xon has been received"),
  	check_status(Status,128,"An Xoff has been transmitted"),
  	check_status(Status,256,"An Xon has been transmitted"),
  	check_status(Status,512,"Input buffer empty when attemptto read"),
  	check_status(Status,1024,"Output buffer full when attemptto write"),
  	write("\nPress Space to continue or Esc to abort"), readchar(Ch),
  	shiftwindow(2), shiftwindow(3),
  	shiftwindow(WD),CH<>'\27'.

  check_status(Status,BitMask,Mess):-
  	bitand(Status,BitMask,V), V<>0, !, nl, write(Mess).
  check_status(_,_,_).
