/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

  Read the file DATA.TRS - convert everything to uppercase and
  send it to a LaserJet compatible printer

****************************************************************/

project "xprinter"

Domains
  FILE = sp
  
include "comglobs.pro"

Predicates
  run
  process_until_eof
  openfile(File,String)
  transmit(Char)
  trans_ch_delay(Char,Integer)
  wait_until_empty_output_buffer(Integer)
  
GOAL
   run.
   
CLAUSES 
    run :-  
	PortNo		= 	1,	/* COM1 */
	InputBufSize	=	1,	/* Size of input buffer */
	OutputBufSize	=	4000,	/* Size of output buffer */
	BaudRate	=	7,	/* 9600 bits per second	*/
	Parity		=	0,	/* No parity		*/
	WordLength	=	3,	/* Eight data bits	*/
	StopBits	=	0,	/* One stop bits	*/
  	Protocol	= 	2,	/* Xon/Xoff can not be used */
  	openRs232(PortNo, InputBufSize, OutputBufSize, BaudRate, Parity,
  		  WordLength, StopBits, Protocol),
	openfile(sp,"DATA.TRS"),!,
	process_until_eof, closefile(sp),
	write("\nPrint Succeded"),
	wait_until_empty_output_buffer(100),
	closeRS232(1).

   run :- closeRS232(1).
/****************************************************************
	Open a file for reading - if possible
*****************************************************************/

openfile(Sp,FileName):-openread(Sp,FileName),!, readdevice(Sp).
openfile(_,FileName) :-write("\nImpossible to open ",FileName),fail.


/****************************************************************
	Read a character from current readdevice
	convert it to uppercase and print it
	Continue this process until eof or a time out event
*****************************************************************/

  process_until_eof:-eof(sp),transmit('\012'),!. /* Send Form Feed */
  process_until_eof:-
	readchar(CH), str_char(S,CH), upper_lower(S2,S), str_char(S2,CH2),
	transmit(CH2), process_until_eof.

  transmit('\010'):-!,trans_ch_delay('\013',10),trans_ch_delay('\010',10).
  transmit(CH)    :-trans_ch_delay(CH,10).

  trans_ch_delay(CH,_):-Txch_RS232(1,CH),!.
  trans_ch_delay(CH,I):-I>0, !,I2=I-1,Ticks(50),trans_ch_delay(CH,I2).
  trans_ch_delay(_,_) :-
	closefile(sp), closeRS232(1),
	write("\nPrinter is not ready, Program aborted"), fail.


/****************************************************************
	Wait until output buffer is empty
*****************************************************************/

  wait_until_empty_output_buffer(_):-
	queuesize_RS232(1,_,Queue), Queue=0,!.
  wait_until_empty_output_buffer(I):-
	I>0,!, I2=I-1,ticks(10),
	wait_until_empty_output_buffer(I2).
  wait_until_empty_output_buffer(_):-write("\nTime out").


