/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Demo of	the pulldown menu
****************************************************************/

include "tdoms.pro"

DATABASE
  pdwstate(ROW,COL,SYMBOL,ROW,COL)

include "tpreds.pro"
include "status.pro"
include "pulldown.pro"

Predicates
  msg(ROW,COL,STRING)

CLAUSES
  /* Pulldown tries first to call pdwaction with the windows open.	*/
  /* If no pdwaction is found CHOICE and SUBCHOICE are returned and	*/
  /* the windows are removed.						*/

  pdwaction(1,1):-msg(3,10,"Input 1 selected").
  pdwaction(1,2):-msg(4,10,"Input 2 selected").
  pdwaction(1,3):-msg(5,10,"Input 3 selected").
  pdwaction(2,0):-msg(5,25,"List all").
  pdwaction(3,1):-msg(3,42,"Load something").
  pdwaction(3,2):-msg(4,42,"Save something").
  pdwaction(3,3):-msg(5,42,"Delete some garbage").
  pdwaction(3,4):-msg(6,42,"Change directory").
  pdwaction(4,1):-msg(3,45,"Actions with directories").
  pdwaction(4,2):-msg(4,45,"Change colors").
  pdwaction(5,0):-msg(15,10,"Please press the space bar."),exit.

  msg(R,C,S):-
        makestatus(112,"Press any key"),
	makewindow(1,32,4,"",R,C,5,30),
	window_str(S),
	readkey(_),
	removewindow,
	removestatus.

GOAL
/*
          1         2         3         4         5         6         7
01234567890123456789012345678901234567890123456789012345678901234567890123456789
     Input          List            Files         Setup          Quit
*/
  makewindow(1,23,0,"",0,0,24,80),
  makestatus(112," Select with arrows or use first upper case letter"),
  pulldown(66,
	  [ curtain(5,"Input",["First","Second","Third"]),
	    curtain(20,"List",[]),
            curtain(36,"Files"    ,["Load","Save","Delete","dIrectory"]),
            curtain(50,"Setup"     ,["Directories","Colors"]),
            curtain(65,"Quit"      ,[])
          ]
       	             ,CH,SUBCH ),
       	write("\n    CH = ",CH),
       	write("\n SUBCH = ",SUBCH),nl.

