/************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

	Access a Reflex(R) compatible data base file
	from Prolog.
	
	We are using the file XREFLEX.RXD for this demo program.

*************************************************************/

project "xreflex"

Domains
  File	= fp

global predicates
  real_ints(REAL,INTEGER,INTEGER,INTEGER,INTEGER)-(o,i,i,i,i) language c

include	"readext.pro"
include	"reflex.pro"

predicates
  /* List data RECORDS */
  list_Recs(FldNames,ReflexRecL)
  list_rec(FldNames,ReflexRec)
  list_elem(ReflexElem)
  PressAKey
  doPrompt

CLAUSES
  list_Recs(_,[]):- !.
  list_Recs(FldNames,[ReflexRec|ReflexRecs]):-
  	nl,nl,
  	list_rec(FldNames,ReflexRec),
  	PressAKey,
  	list_Recs(FldNames,ReflexRecs).

  list_rec([],[]) :- !.
  list_rec([FldName|FldNames],[Elem|Elems]) :-
  	writef("\n%-20: ",FldName),
  	list_elem(Elem),
  	list_rec(FldNames,Elems).

  list_elem(untyped)    :- write("Untyped").
  list_elem(text(Str))  :- write(Str).
  list_elem(date(Date)) :- write(Date).
  list_elem(real(Real)) :- write(Real).
  list_elem(int(Int))   :- write(Int).

  PressAKey :-
  	makewindow(_,_,_,_,MinR,_,NoofR,_),trace(on),
  	cursor(R,_), R<=MinR+NoofR-4,!.

  PressAKey :- doPrompt,cursor(R,C), scroll(R,0),cursor(0,C).

  doPrompt:-
  	makewindow(Nr,Att,_,_,MinR,MinC,NoofR,NoofC),
  	MinR2=MinR+NoofR-1, MinC2=MinC+NoofC/3+1,
  	str_len(" Press a key",Len), Len2=Len+1, bitxor(Att,8,Att2),
  	makewindow(Nr,Att2,0,"",MinR2,MinC2,1,Len2),
  	write(" Press a key"), 
  	readdevice(FP), readdevice(keyboard), readchar(_), readdevice(FP),
  	removewindow.

/*************************************************************
		Goal
*************************************************************/
		
goal	openread(fp,"xreflex.rxd"), readdevice(fp),
	filemode(fp,0),

	/* Build data structure */
	init_Reflex(TotRecs,FldNames,TypeL,TxtPools),
	filepos(fp,DataFilePos,0),
	
	/* Read all data records */
	makewindow(85,41,36," Reflex(R) All Data Records ",0,0,25,40),
	rd_Reflexfile(TotRecs,TypeL,TxtPools,ReflexRecs),
	list_Recs(FldNames,ReflexRecs), doPrompt,
	window_attr(27),

	/* Read data records sequentially */
	makewindow(85,72,33," Reflex(R) Sequential Access ",0,40,25,40),
	filepos(fp,DataFilePos,0),
	rd_ReflexRec(TotRecs,TypeL,TxtPools,Rec),
	nl,nl,
	list_rec(FldNames,Rec),
	PressAKey,fail.
