/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Demo of report generation

 The report generator makes it possible to design a page layout
 as if it were to be a screen layout, and then print that page.
****************************************************************/

include "tdoms.pro"

DOMAINS
  FNAME=SYMBOL
  TYPE = int(); str(); real()
  FIELD = field(STRING,COL)
  FIELDLIST = FIELD*

DATABASE
  /* Database declarations used in scrhnd */
  insmode			/* Global insertmode */
  actfield(FNAME)		/* Actual field */
  screen(SYMBOL,DBASEDOM)	/* Saving different screens */
  value(FNAME,STRING)		/* value of a field */
  field(FNAME,TYPE,ROW,COL,LEN) /* Screen definition */
  txtfield(ROW,COL,LEN,STRING)
  windowsize(ROW,COL).
  notopline

  /* Database declarations used in scrhnd */
  windstart(ROW,COL)
  mycursord(ROW,COL)

  /* Database declarations used in lineinp */
  lineinpstate(STRING,COL)

  /* SPECIFIC FOR THIS APPLICATION */
  payment(STRING)
  delivery
  warranty

include "tpreds.pro"
include "report.pro"

GOAL
	consult("xreport.scr"),
	makewindow(1,31,0,"",0,0,25,80),
	/* writedevice(printer), */
	report(20).

PREDICATES
  nondeterm product(STRING,STRING,REAL)

CLAUSES
  product("1111","Washing Machine",200.35).
  product("2222","Dishwasher",239.67).
  product("3333","Fridge and Freezer",456.78).  
  product("4444","Radio",456.78).  
  product("5555","Television",456.78).  

PREDICATES
  index(INTEGER,STRINGLIST,STRING)
  concatlist(STRINGLIST,STRING)

CLAUSES
  index(1,[H|_],H):-!.
  index(N,[_|T],X):-N>1,N1=N-1,index(N1,T,X).

  concatlist([],"").
  concatlist([H|T],S):-
	concatlist(T,S1),concat(H,S1,S).

CLAUSES
/*******************************************************************
			 Field_value
*******************************************************************/

PREDICATES
  price(FNAME,REAL)

CLAUSES
  price(FNAME,PRICE):-
	value(FNAME,CODE),product(CODE,_,PRICE),!.
  price(_,0).

  field_value(time,TIME):-!,
	time(H,M,S,_),
	str_int(HS,H),str_int(MS,M),str_int(SS,S),
	concatlist([HS,":",MS,":",SS],TIME).

  field_value(date,DATE):-!,
         date(Y,M,D),
         str_int(DS,D),str_int(MS,M),str_int(YS,Y),
         concatlist([MS,"/",DS,"/",YS],DATE).

  field_value(total,TotalS):-!,
        price(item1,P1),
        price(item2,P2),
        price(item3,P3),
        Total=P1+P2+P3,
        str_real(TotalS,Total).
 
  field_value(change,CS):-!,
	value(money,MM),!,str_real(MM,M),
        price(item1,P1),
        price(item2,P2),
        price(item3,P3),
        Total=M-(P1+P2+P3),
        str_real(CS,Total).

  field_value(item1,CODE):-!,value(item1,CODE),!.
  field_value(item2,CODE):-!,value(item2,CODE),!.
  field_value(item3,CODE):-!,value(item3,CODE),!.

  field_value(make1,DESC):-!,value(item1,Code),product(Code,Desc,_),!.
  field_value(make2,DESC):-!,value(item2,Code),product(Code,Desc,_),!.
  field_value(make3,DESC):-!,value(item3,Code),product(Code,Desc,_),!.

  field_value(price1,PRICEs):-!,
	value(item1,Code),product(Code,_,PRICE),!,str_real(PRICEs,PRICE).
  field_value(price2,PRICEs):-!,
	value(item2,Code),product(Code,_,PRICE),!,str_real(PRICEs,PRICE).
  field_value(price3,PRICEs):-!,
	value(item3,Code),product(Code,_,PRICE),!,str_real(PRICEs,PRICE).

  field_value(payment,P):- payment(P),!.

  field_value(delivery,yes):-delivery,!.
  field_value(delivery,no):-!.

  field_value(warranty,yes):-warranty,!. 
  field_value(warranty,no):-!. 

  /* Catch other values from the database */
  field_value(Fn,X):-value(Fn,X),!.

  value("name","J B Gruntfuttock").
  value("street","3 Railway Terrace").
  value("city","Seattle").
  value("state","Washington").
  value("tel","222 333 4444").
  value("item1","1111").
  value("item2","2222").
  value("item3","3333").
  value("money","1000.00").
  payment("Check").
  delivery.
