/*******************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Demo of screen handler
	    Completing a pro-forma invoice
*******************************************************************/

code=3000

include "tdoms.pro"

DOMAINS
  FNAME=SYMBOL
  TYPE = int(); str(); real()
  FILE = myprinter

DATABASE
  /* Database declarations used in scrhnd */
  insmode			/* Global insertmode */
  actfield(FNAME)		/* Actual field */
  screen(SYMBOL,DBASEDOM)	/* Saving different screens */
  value(FNAME,STRING)		/* value of a field */
  field(FNAME,TYPE,ROW,COL,LEN) /* Screen definition */
  txtfield(ROW,COL,LEN,STRING)
  windowsize(ROW,COL).
  notopline

  /* Database declarations used in vscrhnd */
  windstart(ROW,COL)
  mycursord(ROW,COL)

  /* Database declarations used in lineinp */
  lineinpstate(STRING,COL)
  lineinpflag

  /* SPECIFIC FOR THIS APPLICATION */
  payment(STRING)
  delivery
  warranty

CLAUSES
  payment(cash).

include "tpreds.pro"
include "menu.pro"
include "lineinp.pro"
include "status.pro"
include "scrhnd.pro"

GOAL	consult("xshop.scr"),
	makewindow(1,66,66,"Sales Transaction Record",0,0,24,80),
	makestatus(112," Fill in the sales record and press F10 when finished."),
	scrhnd(off,_).

PREDICATES
  index(INTEGER,STRINGLIST,STRING)
  concatlist(STRINGLIST,STRING)

CLAUSES
  index(1,[H|_],H):-!.
  index(N,[_|T],X):-N>1,N1=N-1,index(N1,T,X).

  concatlist([],"").
  concatlist([H|T],S):-
	concatlist(T,S1),concat(H,S1,S).

PREDICATES
  nondeterm product(STRING,STRING,REAL)

CLAUSES
  product("1111","Washing Machine",200.35).
  product("2222","Dishwasher",239.67).
  product("3333","Fridge and Freezer",456.78).  
  product("4444","Radio",456.78).  
  product("5555","Television",456.78).  

CLAUSES
/*******************************************************************
			 Main routines
*******************************************************************/

  noinput(payment).	noinput(delivery).	noinput(warranty).
  noinput(date).	noinput(time).		noinput(total).
  noinput(change).	noinput(make1).		noinput(make2).
  noinput(make3).	noinput(price1).	noinput(price2).
  noinput(price3).

/*******************************************************************
			Field action
*******************************************************************/

PREDICATES
  make(FNAME)

CLAUSES
  field_action(delivery):-retract(delivery),!.
  field_action(delivery):-assert(delivery).
  field_action(warranty):-retract(warranty),!.
  field_action(warranty):-assert(warranty).
  field_action(payment):-retract(payment(_)),fail.
  field_action(payment):-
	cursor(R,C),
	LIST=["Cash","Check","Credit card"],
	menu(R,C,23,23,LIST,"Please select method of payment",1,PayNo),
	index(Payno,LIST,STR),
	assert(payment(STR)). 
  field_action(item1):-!,make(item1).
  field_action(item2):-!,make(item2).
  field_action(item3):-!,make(item3).

  make(FNAME):-retract(value(FNAME,_)),fail.
  make(FNAME):-
	cursor(R,C),
	findall(X,product(X,_,_),CODELIST),
	findall(X,product(_,X,_),LIST),
	menu(R,C,23,23,LIST,"Please select the product",1,Prod),
	index(Prod,CODELIST,CODE),
	assert(value(FNAME,CODE)).

/*******************************************************************
			 Field_value
*******************************************************************/

PREDICATES
  price(FNAME,REAL)

CLAUSES
  price(FNAME,PRICE):-
	value(FNAME,CODE),product(CODE,_,PRICE),!.
  price(_,0).

  field_value(time,TIME):-!,
	time(H,M,S,_),
	str_int(HS,H),str_int(MS,M),str_int(SS,S),
	concatlist([HS,":",MS,":",SS],TIME).

  field_value(date,DATE):-!,
         date(D,M,Y),
         str_int(DS,D),str_int(MS,M),str_int(YS,Y),
         concatlist([DS,":",MS,":",YS],DATE).

  field_value(total,TotalS):-!,
        price(item1,P1),
        price(item2,P2),
        price(item3,P3),
        Total=P1+P2+P3,
        str_real(TotalS,Total).
 
  field_value(change,CS):-!,
	value(money,MM),!,str_real(MM,M),
        price(item1,P1),
        price(item2,P2),
        price(item3,P3),
        Total=M-(P1+P2+P3),
        str_real(CS,Total).

  field_value(item1,CODE):-!,value(item1,CODE),!.
  field_value(item2,CODE):-!,value(item2,CODE),!.
  field_value(item3,CODE):-!,value(item3,CODE),!.

  field_value(make1,DESC):-!,value(item1,Code),product(Code,Desc,_),!.
  field_value(make2,DESC):-!,value(item2,Code),product(Code,Desc,_),!.
  field_value(make3,DESC):-!,value(item3,Code),product(Code,Desc,_),!.

  field_value(price1,PRICEs):-!,
	value(item1,Code),product(Code,_,PRICE),!,str_real(PRICEs,PRICE).
  field_value(price2,PRICEs):-!,
	value(item2,Code),product(Code,_,PRICE),!,str_real(PRICEs,PRICE).
  field_value(price3,PRICEs):-!,
	value(item3,Code),product(Code,_,PRICE),!,str_real(PRICEs,PRICE).

  field_value(payment,P):- payment(P),!.

  field_value(delivery,yes):-delivery,!.
  field_value(delivery,no):-!.

  field_value(warranty,yes):-warranty,!. 
  field_value(warranty,no):-!. 

  /* Catch other values from the database */
  field_value(Fn,X):-value(Fn,X),!.
