/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Demo of	savepic and loadpic
****************************************************************/

project "xslides"

include "tdoms.pro"

DATABASE
  index(CHAR,INTEGER,INTEGER)
  slide(INTEGER,STRING)

GLOBAL PREDICATES
  loadPic(STRING,ROW,COL,ROW,COL,INTEGER,INTEGER) 
	- (i,i,i,i,i,i,i) language c

 SavePic(String) - (i) language c

include "tpreds.pro"
include	"menu.pro"
        
PREDICATES
  mydisplay(ROW,COL,INTEGER)
  findpicture(char,ROW,COL,ROW,COL,INTEGER,INTEGER)
  getnewpositions(ROW,COL,ROW,COL)
  decide(INTEGER)

GOAL
	makewindow(11,7,0,"",0,0,25,80),
	repeat,text,
	menu(10,10,64,23,["Make some slides","See the slide show","Exit"],
                   "Choose an option",1,Choice),
	decide(Choice),text,
	fail.
        
CLAUSES
  decide(1):-
	graphics(1,1,2),
	attribute(2),
	mydisplay(0,0,0).

  decide(2):-
	slide(_,B),graphics(1,1,2),
	loadpic(B,0,0, 0,0,200,320),
	readchar(_),
	clearwindow,
	fail.                        

  decide(3):-exit.

  mydisplay(Row,Col,Slideno):-
	readchar(X),X<>'\027',
	findpicture(X,Row,Col,NewX,NewY,Slideno,NewSlideno),
	mydisplay(NewX,NewY,NewSlideno).

  findpicture('\27',_,_,_,_,_,_):-!,fail.

  findpicture('#',_,_,0,0,Slideno,NewSlideno):-!,
	str_int(SN,Slideno),
	concat("Slide",SN,FSN),
	assert(slide(Slideno,FSN)),
	savepic(FSN),
	graphics(1,1,2),
	NewSlideno=Slideno+1. 

  findpicture(' ',CurrScrRow,CurrScrCol,NewScrRow,NewScrCol,S,S):-!,
	getnewpositions(CurrScrRow,CurrScrCol,NewScrRow,NewScrCol).

  findpicture('\13',CurrScrRow,_,NewScrRow,0,S,S):-!,
	NewScrRow=CurrScrRow+25.

  findpicture(X,CurrScrRow,CurrScrCol,NewScrRow,NewScrCol,S,S):-
	index(X,Row1,Col1), Row=Row1, Col=Col1,
	loadPic("test.pic",Row,Col,CurrScrRow,CurrScrCol,25,25),
	getnewpositions(CurrScrRow,CurrScrCol,NewScrRow,NewScrCol).
                                     
  getnewpositions(X,Y,NewX,0):-Y+34>=300,NewX=X+25.                                                  
  getnewpositions(X,_,0,0):-X+25>=200. 
  getnewpositions(X,Y,X,NewY):-NewY=Y+34.

  index('a',28,64).	index('b',25,94).	index('c',28,128).
  index('d',25,158).	index('e',28,188).	index('f',24,224).
  index('g',26,252).	index('h',54,64).	index('i',52,94).
  index('j',53,127).	index('k',56,158).	index('l',56,188).
  index('m',56,224).	index('n',56,252).	index('o',84,64).
  index('p',84,96).	index('q',84,126).	index('r',84,158).
  index('s',84,192).	index('t',84,224).	index('u',84,256).
  index('v',112,62).	index('w',112,94).	index('x',112,128).
  index('y',112,160).	index('z',112,192).

