/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

	Terminal Emulation program (PC <---> PC or PC <---> Mainframe)
	==========================

	Everything we get from the COM1 will be shown in
	Receive window
	and every character typed using the keyboard will
	be transmitted through COM1.
	
	This process will be aborted when the user presses Esc.

****************************************************************/


project "xterm"

include "tdoms.pro"
include "comglobs.pro"
include "tpreds.pro"
include "status.pro"
include "menu.pro"

Predicates
  run
  terminal
  chk_rdch
  chk_wrch
  rdch_CRLF_RS232(Char)
  wrch_CRLF(Char)
  trans_ch(Char)

GOAL run.

Clauses
  run :-
	makewindow(2, 42,36," Transmit window ", 0,0,12,80),
        makewindow(3, 63,5," Receive window ", 12,0,12,80),
	PortNo		= 	1,	/* COM1 */
	InputBufSize	=	1,	/* Size of input buffer */
	OutputBufSize	=	1,	/* Size of output buffer */
	BaudRate	=	7,	/* 9600 bits per second	*/
	Parity		=	0,	/* No parity		*/
	WordLength	=	3,	/* Eight data bits	*/
	StopBits	=	0,	/* One stop bits	*/
  	Protocol	= 	0,	/* Fully asynchronous	*/
  	openRs232(PortNo, InputBufSize, OutputBufSize, BaudRate, Parity,
  		  WordLength, StopBits, Protocol),
	terminal, !,closeRS232(1).

  run :- closeRS232(1).


/****************************************************************/
/*								*/
/*		TERMINAL MODE					*/
/*		Transmission without time out			*/
/*								*/
/****************************************************************/

  terminal :- chk_rdch, chk_wrch,terminal.

  chk_rdch :- rdch_CRLF_RS232(CH),!,shiftwindow(3), write(CH).
  chk_rdch.

  chk_wrch :- shiftwindow(2), cursor(R,C),cursor(R,C),not(keypressed),!.
  chk_wrch :- readchar(CH),CH<>'\027', wrch_CRLF(CH).
  
  rdch_CRLF_RS232(CH) :- Rxch_RS232(1,CH), CH<>'\013'.
  
  wrch_CRLF('\013') :- !,nl, trans_ch('\013'), trans_ch('\010').
  wrch_CRLF(CH) :- write(CH), trans_ch(CH).
  
  trans_ch(CH) :- Txch_RS232(1,CH),!.
  trans_ch(CH) :- trans_ch(CH).
