/*******************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		     Demo of screen handler
	      Will you reach your destination in time ?
*******************************************************************/

code=2000

include "tdoms.pro"

DOMAINS
  FNAME=SYMBOL
  TYPE = int(); str(); real()

DATABASE
  /* Database declarations used in SCRHND.PRO */
  insmode			/* Global insertmode */
  actfield(FNAME)		/* Actual field */
  screen(SYMBOL,DBASEDOM)	/* Saving different screens*/
  value(FNAME,STRING)		/* value of a field */
  field(FNAME,TYPE,ROW,COL,LEN)	/* Screen definition */
  txtfield(ROW,COL,LEN,STRING)
  windowsize(ROW,COL).
  notopline

  /* database predicates used by VSCRHND.PRO */
  windstart(ROW,COL)
  mycursord(ROW,COL)

  /* Database declarations used in LINEIN.PRO */
  lineinpstate(STRING,COL)
  lineinpflag

  flip(STRING).

include "tpreds.pro"
include "status.pro"
include "lineinp.pro"
include "scrhnd.pro"

PREDICATES
  timesplit(STRING,INTEGER,INTEGER,INTEGER)
  timediff(STRING,STRING,REAL)
  std(STRING,STRING)  

GOAL consult("xtravel.scr"), createwindow(off), scrhnd(off,_).

CLAUSES
/*******************************************************************
   			Field action				   
********************************************************************/

  field_action(timenow):-
  	makewindow(1,7,7,"Set new time",5,5,8,40),
  	write("Hours:  \t"),readint(H),nl,
  	write("Minutes:\t"),readint(M),nl,
  	write("Seconds:\t"),readint(S),
  	time(H,M,S,0),fail.

  field_action(timenow):-
	removewindow.  	

  field_action(speed):-
  	makewindow(1,7,7,"Speed Window",5,5,8,40),
  	write("\n   This is not an input window."),sound(100,300),
  	readchar(_),
  	removewindow.

/*******************************************************************
 			 Field_value
*********************************************************************/

  field_value(timenow,TIME):-!,
	time(Ho,M,S,H),
	T=S+((H+50) div 100),
	str_int(Seconds,T),std(Seconds,SecondsSt),
	str_int(Minutes,M),std(Minutes,MinutesSt),
	str_int(Hour,Ho),
	std(Hour,HourSt),
	concat(HourSt,":",S1),concat(S1,MinutesSt,S2),concat(S2,":",S3),
	concat(S3,SecondsSt,Time).

  field_value(speed,NecSpeed):-!,
	field_value(timenow,TimeStr),
	value(arrivet,ArriveStr),
	timediff(ArriveStr,TimeStr,TimeSecs),
	value(miles,MileStr),!,
	str_real(MileStr,NoOfMiles),
	RealSpeed = NoOfMiles/(TimeSecs/3600),
	str_real(NecSpeed,RealSpeed).

  field_value(flip,STR2):-!,
	time(_,_,_,H), F=H*100+10,sound(1,F),
	retract(flip(STR)),
	frontchar(STR,CH,STR1),
	str_char(CHS,CH),
	concat(STR1,CHS,STR2),
	assert(flip(STR2)),!.

  field_value(Fn,X):-value(Fn,X),!.   /* Values from normal user input */

  flip("                            ").

/*******************************************************************
  			 noinput				   
********************************************************************/

  noinput(speed).	 	
  noinput(timenow).
  noinput(flip).

/*******************************************************************
  			 Intermediate predicates
********************************************************************/

DOMAINS
  ILIST = INTEGER*

PREDICATES
  str_intgl(STRING,ILIST)

CLAUSES
  str_intgl("",[]):-!.
  str_intgl(STR,[H|T]):-
	fronttoken(STR,INTSTR,REST),
	str_int(INTSTR,H),!,
	str_intgl(REST,T).
  str_intgl(STR,T):-
	fronttoken(STR,_,REST),
	str_intgl(REST,T).

  timesplit(TimeStr,H,M,S):-
	str_intgl(Timestr,Intglist),
	Intglist=[H,M,S].

  timediff(TimeStr1,TimeStr2,DiffSecs):-
	timesplit(TimeStr1,H1,M1,S1),
	timesplit(TimeStr2,H2,M2,S2),
	TotSecs1 = H1*3600.0+M1*60+S1,
	TotSecs2 = H2*3600.0+M2*60+S2,
	DiffSecs=TotSecs1-TotSecs2.					

 std(H,HS):-str_len(H,L),L<2,!,concat("0",H,HS).		
 std(H,H).
