/****************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

		Demo of treemenu
****************************************************************/

/* To see how a menu tree is drawn, try the following trace 
   with the editor window turned off. 

   shorttrace scr_char field_attr field_str                  */

code=2000

include "tdoms.pro"

DOMAINS
  SELECTOR=INTEGER
  TREE = tree(STRING,SELECTOR,TREELIST)
  TREELIST = TREE*

DATABASE
  treewindow(ROW,COL)
  treechoice(SELECTOR)

include "tpreds.pro"
include "status.pro"
include "menu.pro"
include "tree.pro"

CLAUSES
  treeaction(_):-
	cursor(R,C),
	makewindow(_,_,_,_,SR,SC,_,_),
	RR=R+SR, CC=C+SC,
	menu(RR,CC,32,33,[continue,select],test,0,CH),
	CH=2.

PREDICATES
  test
  show(SYMBOL)

CLAUSES
  show(DIRECTION):-
	treemenu(DIRECTION,tree("start",1,
		[tree("start_problem",2,
			[tree("gasoline_help",3,[]),
			 tree("electrical_system",4,
			 	[tree("battery_flat",5,
			 		[tree("another",6,[]),
			 		 tree("recharge",7,[]),
			 		 tree("push_start",8,[])]),
			 	 tree("wet_weather",9,[])]),
			 tree("alternative",10,[])]),
		 tree("overheating",11,[]),
		 tree("smell",12,[]),
		 tree("vibration",13,[]),
		 tree("start_last",14,
		 	[tree("bad_running",15,
		 		[tree("bad_idling",16,[]),
		 		 tree("lack_of_power",17,[])]),
			 tree("brakes",18,[]),
			 tree("wiper",19,[]),
			 tree("lights",20,[]),
			 tree("horn",21,[])])]),
	CHOICE),
	clearwindow,
	write("Choice= ",CHOICE),nl.

 test:-	makewindow(5,66,23,"",5,5,20,70),
	write("You are invited to make a selection from a tree menu.\n\n"),
	write("The menu will be shown with the tree drawn in a total of\n\n"),
	write("four different attitudes.\n\n"),
	write("Each time you press F10 or Esc, or make a selection by pressing\n\n"),
	write("RETURN while the cursor is in a field, the menu will reappear\n\n"),
	write("with the tree drawn in a new attitude.\n\n"),
	write("You can move around the tree by using the cursor keys.\n\n"),
	write(".. Press the space bar to begin ......"),readkey(_),
	removewindow,fail.
 test:-	show(right),fail.
 test:-	show(left),fail.
 test:-	show(down),fail.
 test:-	show(up),fail.

GOAL test.
